/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.unity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.unity.UnityAdsAdapterUtils;
import com.google.ads.mediation.unity.UnityAdsLoader;
import com.google.ads.mediation.unity.UnityBannerViewFactory;
import com.google.ads.mediation.unity.UnityBannerViewWrapper;
import com.google.ads.mediation.unity.UnityInitializer;
import com.google.ads.mediation.unity.UnityMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;

@Keep
public class UnityMediationBannerAd
implements MediationBannerAd,
BannerView.IListener {
    private String bannerPlacementId;
    private String gameId;
    @Nullable
    private MediationBannerAdCallback mediationBannerAdCallback;
    private final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationBannerAdLoadCallback;
    private final MediationBannerAdConfiguration mediationBannerAdConfiguration;
    private final UnityInitializer unityInitializer;
    private final UnityBannerViewFactory unityBannerViewFactory;
    @Nullable
    private UnityBannerViewWrapper unityBannerViewWrapper;
    private final UnityAdsLoader unityAdsLoader;
    static final String ERROR_MSG_NO_MATCHING_AD_SIZE = "There is no matching Unity Ads ad size for Google ad size: ";
    static final String ERROR_MSG_INITIALIZATION_FAILED_FOR_GAME_ID = "Unity Ads initialization failed for game ID '%s' with error message: %s";

    public UnityMediationBannerAd(@NonNull MediationBannerAdConfiguration bannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> bannerAdLoadCallback, @NonNull UnityInitializer unityInitializer, @NonNull UnityBannerViewFactory unityBannerViewFactory, @NonNull UnityAdsLoader unityAdsLoader) {
        this.mediationBannerAdConfiguration = bannerAdConfiguration;
        this.mediationBannerAdLoadCallback = bannerAdLoadCallback;
        this.unityBannerViewFactory = unityBannerViewFactory;
        this.unityInitializer = unityInitializer;
        this.unityAdsLoader = unityAdsLoader;
    }

    public void onBannerLoaded(BannerView bannerView) {
        String logMessage = String.format("Unity Ads finished loading banner ad for placement ID: %s", bannerView.getPlacementId());
        Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
        this.mediationBannerAdCallback = (MediationBannerAdCallback)this.mediationBannerAdLoadCallback.onSuccess((Object)this);
    }

    public void onBannerClick(BannerView bannerView) {
        String logMessage = String.format("Unity Ads banner ad was clicked for placement ID: %s", bannerView.getPlacementId());
        Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
        if (this.mediationBannerAdCallback == null) {
            return;
        }
        this.mediationBannerAdCallback.reportAdClicked();
        this.mediationBannerAdCallback.onAdOpened();
    }

    public void onBannerFailedToLoad(BannerView bannerView, BannerErrorInfo bannerErrorInfo) {
        int errorCode = UnityAdsAdapterUtils.getMediationErrorCode(bannerErrorInfo);
        AdError loadError = UnityAdsAdapterUtils.createAdError(errorCode, bannerErrorInfo.errorMessage);
        Log.w((String)UnityMediationAdapter.TAG, (String)loadError.toString());
        this.mediationBannerAdLoadCallback.onFailure(loadError);
    }

    public void onBannerLeftApplication(BannerView bannerView) {
        String logMessage = String.format("Unity Ads banner ad left application for placement ID: %s", bannerView.getPlacementId());
        Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
        if (this.mediationBannerAdCallback == null) {
            return;
        }
        this.mediationBannerAdCallback.onAdLeftApplication();
    }

    public void onBannerShown(BannerView bannerView) {
        String logMessage = String.format("Unity Ads banner ad was shown for placement ID: %s", bannerView.getPlacementId());
        Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
        if (this.mediationBannerAdCallback != null) {
            this.mediationBannerAdCallback.reportAdImpression();
        }
    }

    public void loadAd() {
        final Context context = this.mediationBannerAdConfiguration.getContext();
        Bundle serverParameters = this.mediationBannerAdConfiguration.getServerParameters();
        AdSize adSize = this.mediationBannerAdConfiguration.getAdSize();
        this.gameId = serverParameters.getString("gameId");
        this.bannerPlacementId = serverParameters.getString("zoneId");
        if (!UnityAdsAdapterUtils.areValidIds(this.gameId, this.bannerPlacementId)) {
            AdError adError = new AdError(101, "Missing or invalid server parameters.", "com.google.ads.mediation.unity");
            Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
            this.mediationBannerAdLoadCallback.onFailure(adError);
            return;
        }
        if (!(context instanceof Activity)) {
            AdError adError = new AdError(105, "Unity Ads requires an Activity context to load ads.", "com.google.ads.mediation.unity");
            Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
            this.mediationBannerAdLoadCallback.onFailure(adError);
            return;
        }
        final Activity activity = (Activity)context;
        final UnityBannerSize unityBannerSize = UnityAdsAdapterUtils.getUnityBannerSize(context, adSize);
        if (unityBannerSize == null) {
            String errorMessage = ERROR_MSG_NO_MATCHING_AD_SIZE + adSize;
            AdError adError = new AdError(110, errorMessage, "com.google.ads.mediation.unity");
            Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
            this.mediationBannerAdLoadCallback.onFailure(adError);
            return;
        }
        final String adMarkup = this.mediationBannerAdConfiguration.getBidResponse();
        this.unityInitializer.initializeUnityAds(context, this.gameId, new IUnityAdsInitializationListener(){

            public void onInitializationComplete() {
                String logMessage = String.format("Unity Ads is initialized for game ID '%s' and can now load banner ad with placement ID: %s", UnityMediationBannerAd.this.gameId, UnityMediationBannerAd.this.bannerPlacementId);
                Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
                UnityAdsAdapterUtils.setCoppa(MobileAds.getRequestConfiguration().getTagForChildDirectedTreatment(), context);
                if (UnityMediationBannerAd.this.unityBannerViewWrapper == null) {
                    UnityMediationBannerAd.this.unityBannerViewWrapper = UnityMediationBannerAd.this.unityBannerViewFactory.createBannerView(activity, UnityMediationBannerAd.this.bannerPlacementId, unityBannerSize);
                }
                UnityMediationBannerAd.this.unityBannerViewWrapper.setListener(UnityMediationBannerAd.this);
                UnityAdsLoadOptions loadOptions = UnityMediationBannerAd.this.unityAdsLoader.createUnityAdsLoadOptions();
                loadOptions.set("watermark", UnityMediationBannerAd.this.mediationBannerAdConfiguration.getWatermark());
                if (adMarkup != null) {
                    loadOptions.setAdMarkup(adMarkup);
                }
                UnityMediationBannerAd.this.unityBannerViewWrapper.load(loadOptions);
            }

            public void onInitializationFailed(UnityAds.UnityAdsInitializationError unityAdsInitializationError, String errorMessage) {
                String adErrorMessage = String.format(UnityMediationBannerAd.ERROR_MSG_INITIALIZATION_FAILED_FOR_GAME_ID, UnityMediationBannerAd.this.gameId, errorMessage);
                AdError adError = UnityAdsAdapterUtils.createSDKError(unityAdsInitializationError, adErrorMessage);
                Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
                UnityMediationBannerAd.this.mediationBannerAdLoadCallback.onFailure(adError);
            }
        });
    }

    @NonNull
    public View getView() {
        return this.unityBannerViewWrapper.getBannerView();
    }
}

