/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.unity;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.google.ads.mediation.unity.UnityAdsWrapper;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.metadata.MediationMetaData;

public class UnityInitializer {
    static final String ADMOB = "AdMob";
    static final String KEY_ADAPTER_VERSION = "adapter_version";
    private static UnityInitializer unityInitializerInstance;
    private final UnityAdsWrapper unityAdsWrapper;

    static synchronized UnityInitializer getInstance() {
        if (unityInitializerInstance == null) {
            unityInitializerInstance = new UnityInitializer();
        }
        return unityInitializerInstance;
    }

    private UnityInitializer() {
        this.unityAdsWrapper = new UnityAdsWrapper();
    }

    @VisibleForTesting
    UnityInitializer(UnityAdsWrapper unityAdsWrapper) {
        this.unityAdsWrapper = unityAdsWrapper;
    }

    public void initializeUnityAds(Context context, String gameId, IUnityAdsInitializationListener initializationListener) {
        if (this.unityAdsWrapper.isInitialized()) {
            initializationListener.onInitializationComplete();
            return;
        }
        MediationMetaData mediationMetaData = this.unityAdsWrapper.getMediationMetaData(context);
        mediationMetaData.setName(ADMOB);
        mediationMetaData.setVersion(this.unityAdsWrapper.getVersion());
        mediationMetaData.set(KEY_ADAPTER_VERSION, (Object)"4.12.1.0");
        mediationMetaData.commit();
        this.unityAdsWrapper.initialize(context, gameId, initializationListener);
    }
}

