/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mintegral.bidding;

import android.content.Context;
import android.os.Looper;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.base.BaseQueryPrice;
import com.hisavana.common.bean.Network;
import com.hisavana.common.constant.ComConstants;
import com.hisavana.common.interfacz.IBidWithNotify;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.mintegral.check.ExistsCheck;
import com.hisavana.mintegral.check.MBridgeSDKManager;
import com.mbridge.msdk.mbbid.out.BannerBidRequestParams;
import com.mbridge.msdk.mbbid.out.BidListennning;
import com.mbridge.msdk.mbbid.out.BidLossCode;
import com.mbridge.msdk.mbbid.out.BidManager;
import com.mbridge.msdk.mbbid.out.BidResponsed;
import com.mbridge.msdk.mbbid.out.CommonBidRequestParams;
import com.mbridge.msdk.mbbid.out.SplashBidRequestParams;
import com.transsion.core.CoreUtil;
import com.transsion.core.pool.TranssionPoolManager;
import java.util.ArrayList;

public class MintegralBidding
extends BaseQueryPrice {
    private int c;
    private BidManager d;
    int a;
    int b;

    public void setBannerSize(int n) {
        this.c = n;
    }

    public void queryPrice(Context context, final Network network) {
        if (network == null || context == null) {
            return;
        }
        final long l = System.currentTimeMillis();
        ExistsCheck.initAdSource(network.getApplicationId(), network.getApplicationKey(), new MBridgeSDKManager.MBridgeSDKInitializeListener(){

            @Override
            public void onInitializeSuccess(String string, String string2) {
                long l2 = System.currentTimeMillis() - l;
                AdLogUtil.Log().d("mintegral_log", "onInitializeSuccess\uff0cinit time " + l2);
                MintegralBidding.this.startQueryPrice(network);
            }

            @Override
            public void onInitializeFailure(String string) {
                AdLogUtil.Log().d("mintegral_log", "init onError message\uff1a" + string);
            }
        });
    }

    public void startQueryPrice(final Network network) {
        if (network == null) {
            return;
        }
        switch (network.getAdt()) {
            case 2: {
                this.a();
                this.d = new BidManager((CommonBidRequestParams)new BannerBidRequestParams("", network.getCodeSeatId(), this.b, this.a));
                break;
            }
            case 4: {
                AdLogUtil.Log().d("mintegral_log", "*---->mintegral bidding getOrientation() --- :" + this.getOrientation());
                this.d = new BidManager((CommonBidRequestParams)new SplashBidRequestParams("", network.getCodeSeatId(), true, this.getOrientation(), 30, 30));
                break;
            }
            default: {
                this.d = new BidManager("", network.getCodeSeatId());
            }
        }
        final long l = System.currentTimeMillis();
        this.trackingBiddingStart();
        this.d.setBidListener(new BidListennning(){

            public void onFailed(String string) {
                long l2 = System.currentTimeMillis() - l;
                AdLogUtil.Log().d("mintegral_log", "*---->mintegral bidding request fail --- :" + string + ",time use:" + l2);
                if (network == null) {
                    return;
                }
                MintegralBidding.this.trackingBiddingFailed(-1, string);
                Preconditions.runOnMainThread(() -> {
                    if (MintegralBidding.this.mQueryPriceListener != null) {
                        MintegralBidding.this.mQueryPriceListener.onQueryPriceFailed();
                    }
                });
            }

            public void onSuccessed(BidResponsed bidResponsed) {
                long l2 = System.currentTimeMillis() - l;
                if (bidResponsed == null || network == null) {
                    return;
                }
                Double d = 0.0;
                try {
                    d = Double.parseDouble(bidResponsed.getPrice()) * 100.0;
                }
                catch (Exception exception) {
                    AdLogUtil.Log().e("mintegral_log", "*----> mintegral bidding success ---,price is:" + d + ",id:" + network.getCodeSeatId() + ",time use:" + l2);
                }
                MintegralBidding.this.trackingBiddingSuccess(d);
                network.setPrice(d);
                network.setBidInfo((IBidWithNotify)new BidWithNotify(bidResponsed));
                AdLogUtil.Log().d("mintegral_log", "*----> mintegral bidding success ---,price is:" + d + ",id:" + network.getCodeSeatId());
                Preconditions.runOnMainThread(() -> {
                    if (MintegralBidding.this.mQueryPriceListener != null) {
                        ArrayList<Network> arrayList = new ArrayList<Network>();
                        arrayList.add(network);
                        MintegralBidding.this.mQueryPriceListener.onQueryPriceSuccess(arrayList);
                    }
                });
            }
        });
        this.d.bid();
    }

    private void a() {
        switch (this.c) {
            case 0: {
                this.a = 50;
                this.b = 320;
                break;
            }
            case 1: {
                this.a = 100;
                this.b = 320;
                break;
            }
            case 3: {
                this.a = 90;
                this.b = 320;
                break;
            }
            case 2: {
                this.a = 250;
                this.b = 320;
                break;
            }
            default: {
                this.a = 50;
                this.b = 320;
            }
        }
    }

    public void destroy() {
        this.mQueryPriceListener = null;
    }

    private static class BidWithNotify
    implements IBidWithNotify {
        private final BidResponsed a;
        private boolean b = false;
        private long c;

        BidWithNotify(BidResponsed bidResponsed) {
            this.a = bidResponsed;
            this.c = System.currentTimeMillis();
        }

        public void notifyWin() {
            if (this.a == null) {
                return;
            }
            AdLogUtil.Log().d("mintegral_log", "notify mintegral bidding win");
            if (Looper.myLooper() == Looper.getMainLooper()) {
                TranssionPoolManager.getInstance().addTask(() -> {
                    this.a.sendWinNotice(CoreUtil.getContext());
                    this.b = true;
                });
            } else {
                this.a.sendWinNotice(CoreUtil.getContext());
                this.b = true;
            }
        }

        public void notifyLoss() {
            if (this.b || this.a == null) {
                return;
            }
            AdLogUtil.Log().d("mintegral_log", "notify mintegral bidding failed");
            if (Looper.myLooper() == Looper.getMainLooper()) {
                TranssionPoolManager.getInstance().addTask(() -> this.a.sendLossNotice(CoreUtil.getContext(), BidLossCode.bidPriceNotHighest()));
            } else {
                this.a.sendLossNotice(CoreUtil.getContext(), BidLossCode.bidPriceNotHighest());
            }
        }

        public String getPayload() {
            if (this.a == null) {
                return "";
            }
            AdLogUtil.Log().d("mintegral_log", "mintegral getPayload" + this.a.getBidToken());
            return this.a.getBidToken();
        }

        public boolean isExpired() {
            return Math.abs(System.currentTimeMillis() - this.c) > (long)ComConstants.BID_PRICE_CACHE_TIME;
        }
    }
}

