/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mintegral.executer;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.mintegral.check.MBridgeSDKManager;
import com.mbridge.msdk.out.BannerAdListener;
import com.mbridge.msdk.out.BannerSize;
import com.mbridge.msdk.out.MBBannerView;
import com.mbridge.msdk.out.MBridgeIds;

public class MintegralBanner
extends BaseBanner {
    private MBBannerView a;
    private BannerAdListener b = new BannerAdListener(){

        public void onLoadFailed(MBridgeIds mBridgeIds, String string) {
            MintegralBanner.this.adFailedToLoad(new TAdErrorCode(1043, string));
            AdLogUtil.Log().d("mintegral_log", "Mintegral onLoadFailed message\uff1a" + string);
        }

        public void onLoadSuccessed(MBridgeIds mBridgeIds) {
            AdLogUtil.Log().d("mintegral_log", "Mintegral Ads onLoadSuccessed");
            MintegralBanner.this.adLoaded();
        }

        public void onClick(MBridgeIds mBridgeIds) {
            AdLogUtil.Log().d("mintegral_log", "Mintegral Ads onClick");
            MintegralBanner.this.adClicked();
        }

        public void onLeaveApp(MBridgeIds mBridgeIds) {
            AdLogUtil.Log().d("mintegral_log", "Mintegral Ads onLeaveApp");
        }

        public void showFullScreen(MBridgeIds mBridgeIds) {
            AdLogUtil.Log().d("mintegral_log", "Mintegral Ads showFullScreen");
        }

        public void closeFullScreen(MBridgeIds mBridgeIds) {
            AdLogUtil.Log().d("mintegral_log", "Mintegral Ads closeFullScreen");
        }

        public void onLogImpression(MBridgeIds mBridgeIds) {
            AdLogUtil.Log().d("mintegral_log", "Mintegral Ads onAdShowed");
            MintegralBanner.this.adImpression();
        }

        public void onCloseBanner(MBridgeIds mBridgeIds) {
            AdLogUtil.Log().d("mintegral_log", "Mintegral Ads onCloseBanner");
            MintegralBanner.this.adClosed();
        }
    };
    private BannerSize c;

    public MintegralBanner(Context context, Network network, int n) {
        super(context, network);
        switch (n) {
            case 0: {
                this.c = new BannerSize(4, 0, 0);
                break;
            }
            case 1: {
                this.c = new BannerSize(5, 320, 100);
                break;
            }
            case 3: {
                this.c = new BannerSize(2, 0, 0);
                break;
            }
            case 2: {
                this.c = new BannerSize(2, 0, 0);
                break;
            }
            default: {
                this.c = new BannerSize(4, 0, 0);
            }
        }
    }

    protected void onBannerDestroy() {
        AdLogUtil.Log().d("mintegral_log", "onBannerDestroy");
        if (this.a != null) {
            this.a.release();
            this.a = null;
        }
        this.b = null;
    }

    protected View getBanner() {
        AdLogUtil.Log().d("mintegral_log", "getBanner " + this.a);
        if (null == this.a && this.mContext != null && this.mContext.get() != null) {
            this.a = new MBBannerView((Context)this.mContext.get());
            this.a.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        return this.a;
    }

    protected void onBannerLoad() {
        AdLogUtil.Log().d("mintegral_log", "onBannerLoad");
        if (MBridgeSDKManager.getInstance().getCurrentState() == MBridgeSDKManager.MBridgeSDKInitializeState.SDK_STATE_INITIALIZE_SUCCESS) {
            if (this.a == null || this.mNetwork == null || TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId()) || this.b == null || TextUtils.isEmpty(this.mNetwork.getBidInfo() != null ? this.mNetwork.getBidInfo().getPayload() : null)) {
                this.adFailedToLoad(new TAdErrorCode(1043, "Mintegral Ads failed to load ad error with param is empty"));
                return;
            }
            this.a.init(this.c, "", this.mNetwork.getCodeSeatId());
            this.a.setBannerAdListener(this.b);
            this.a.loadFromBid(this.mNetwork.getBidInfo().getPayload());
            this.mNetwork.setBidInfo(null);
        } else {
            this.adFailedToLoad(new TAdErrorCode(1042, "Mintegral Ads failed to load ad error with param empty"));
            AdLogUtil.Log().d("mintegral_log", "init onError ");
        }
    }

    protected void showBanner() {
        AdLogUtil.Log().d("mintegral_log", "showBanner");
        if (this.a != null) {
            this.a.setVisibility(0);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("mintegral_log", "destroy" + this.getLogString());
    }
}

