/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mintegral.executer;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.hisavana.common.base.BaseNative;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.AdUtil;
import com.hisavana.mintegral.util.PlatformUtil;
import com.mbridge.msdk.out.Campaign;
import com.mbridge.msdk.out.Frame;
import com.mbridge.msdk.out.MBBidNativeHandler;
import com.mbridge.msdk.out.NativeListener;
import com.mbridge.msdk.out.OnMBMediaViewListenerPlus;
import com.transsion.core.CoreUtil;
import java.util.List;
import java.util.Map;

public class MintegralNative
extends BaseNative {
    private MBBidNativeHandler a;
    private NativeListener.NativeAdListener b = new NativeListener.NativeAdListener(){

        public void onAdLoaded(List<Campaign> list, int n) {
            AdLogUtil.Log().d("mintegral_log", "onAdLoad");
            int n2 = 0;
            if (list != null && !list.isEmpty()) {
                for (Campaign campaign : list) {
                    TAdNativeInfo tAdNativeInfo = PlatformUtil.getTAdNativeInfo(campaign, MintegralNative.this.mAdt, MintegralNative.this.getTtl(), MintegralNative.this);
                    n2 = MintegralNative.this.filter(tAdNativeInfo);
                    if (n2 == 0) {
                        MintegralNative.this.mNatives.add(tAdNativeInfo);
                        continue;
                    }
                    AdUtil.release((TAdNativeInfo)tAdNativeInfo);
                }
                if (!MintegralNative.this.mNatives.isEmpty()) {
                    MintegralNative.this.adLoaded(MintegralNative.this.mNatives);
                } else {
                    MintegralNative.this.adFailedToLoad(new TAdErrorCode(n2, "ad filter"));
                    AdLogUtil.Log().w("mintegral_log", "ad not pass sensitive check or no icon or image filter:" + n2);
                }
            }
        }

        public void onAdLoadError(String string) {
            MintegralNative.this.adFailedToLoad(new TAdErrorCode(1043, string));
            AdLogUtil.Log().d("mintegral_log", "Mintegral onLoadFailed message\uff1a" + string);
        }

        public void onAdClick(Campaign campaign) {
            MintegralNative.this.adClicked(MintegralNative.this.d);
            AdLogUtil.Log().d("mintegral_log", "Mintegral Ads onAdClick");
        }

        public void onAdFramesLoaded(List<Frame> list) {
        }

        public void onLoggingImpression(int n) {
            MintegralNative.this.adImpression(MintegralNative.this.d);
            AdLogUtil.Log().d("mintegral_log", "Mintegral Ads onLoggingImpression");
        }
    };
    private OnMBMediaViewListenerPlus c = new OnMBMediaViewListenerPlus(){

        public void onEnterFullscreen() {
        }

        public void onExitFullscreen() {
        }

        public void onStartRedirection(Campaign campaign, String string) {
        }

        public void onFinishRedirection(Campaign campaign, String string) {
        }

        public void onRedirectionFailed(Campaign campaign, String string) {
        }

        public void onVideoAdClicked(Campaign campaign) {
            MintegralNative.this.adClicked(MintegralNative.this.d);
        }

        public void onVideoStart() {
        }

        public void onVideoComplete() {
        }
    };
    private AdNativeInfo d;

    public MintegralNative(Context context, Network network, int n) {
        super(context, network, n);
    }

    protected void onNativeAdStartLoad() {
    }

    protected void initNative() {
        if (this.mNetwork == null || TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId()) || this.b == null || TextUtils.isEmpty(this.mNetwork.getBidInfo() != null ? this.mNetwork.getBidInfo().getPayload() : null)) {
            this.adFailedToLoad(new TAdErrorCode(1040, "Mintegral Ads failed to load ad error with param empty"));
            return;
        }
        Map map = MBBidNativeHandler.getNativeProperties((String)"", (String)this.mNetwork.getCodeSeatId());
        map.put("ad_num", this.mAdCount);
        map.put("videoSupport", true);
        this.a = new MBBidNativeHandler(map, CoreUtil.getContext());
        this.a.setAdListener(this.b);
        this.a.bidLoad(this.mNetwork.getBidInfo().getPayload());
        this.mNetwork.setBidInfo(null);
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.a != null) {
            this.a.bidRelease();
        }
        this.a = null;
        this.b = null;
        this.c = null;
        this.d = null;
        AdLogUtil.Log().d("mintegral_log", "destroy" + this.getLogString());
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, AdNativeInfo adNativeInfo) {
        this.logTrigerShow((TAdNativeInfo)adNativeInfo);
        this.d = adNativeInfo;
        if (this.a != null && adNativeInfo != null && adNativeInfo.getNativeAdWrapper() != null && adNativeInfo.getNativeAdWrapper().getNativeAd() != null && adNativeInfo.getNativeAdWrapper().getNativeAd() instanceof Campaign) {
            this.a.registerView((View)viewGroup, list, (Campaign)adNativeInfo.getNativeAdWrapper().getNativeAd());
        } else {
            this.onAdShowError(TAdErrorCode.ERROR_AD_IS_NULL);
            AdLogUtil.Log().e("mintegral_log", "registerViewForInteraction error");
        }
    }

    public void unregisterView(@NonNull AdNativeInfo adNativeInfo) {
    }

    public OnMBMediaViewListenerPlus getOnMBMediaViewListenerPlus() {
        return this.c;
    }
}

