/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adxlibrary.excuter;

import android.content.Context;
import com.cloud.hisavana.sdk.api.adx.AInterstitial;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;

public class AdxInterstitia
extends BaseInterstitial {
    private AInterstitial d;

    public AdxInterstitia(Context context, Network network) {
        super(context, network);
        AdLogUtil.Log().d("AdxInterstitia", "placemen id:=" + network.codeSeatId);
    }

    protected void onInterstitialStartLoad() {
        if (this.d != null && !this.d.isLoaded()) {
            this.d.setDefaultAd(this.mIsDefaultAd);
            this.d.loadAd();
        }
        AdLogUtil.Log().d("AdxInterstitia", "adx mInterstitialAd load mPlacementId:" + this.mNetwork.codeSeatId);
    }

    protected void initInterstitial() {
        if (this.d == null && this.mContext != null && this.mContext.get() != null) {
            this.d = new AInterstitial(this.mNetwork.codeSeatId);
            SspAd.AppId = this.mNetwork.getApplicationId();
            TaRequest taRequest = new TaRequest.TaRequestBuild().setListener(new AdListener(){

                public void onError(TaErrorCode taErrorCode) {
                    AdLogUtil.Log().e("AdxInterstitia", "interstitial onError:errorCode:" + taErrorCode.getErrorCode() + ",errorMessage:" + taErrorCode.getErrorMessage());
                    AdxInterstitia.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                }

                public void onAdClosed() {
                    AdLogUtil.Log().d("AdxInterstitia", "interstitial is closed");
                    AdxInterstitia.this.adClosed();
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d("AdxInterstitia", "interstitial is Loaded");
                    AdxInterstitia.this.adLoaded();
                }

                public void onAdClicked(DownUpPointBean downUpPointBean) {
                    AdLogUtil.Log().d("AdxInterstitia", "interstitial is click");
                    AdxInterstitia.this.adClicked();
                }

                public void onTimeOut() {
                    AdxInterstitia.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                }
            }).build();
            this.d.setAdRequest(taRequest);
        }
    }

    public boolean isExpired() {
        return super.isExpired();
    }

    protected void onInterstitialShow() {
        if (this.d != null) {
            this.d.show();
        }
    }

    public boolean isLoaded() {
        return this.d != null && this.d.isLoaded();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.d != null) {
            this.d.destroy();
            this.d = null;
            AdLogUtil.Log().d("AdxInterstitia", "adx interstitial destroy");
        }
    }
}

