/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import com.cloud.hisavana.sdk.api.adx.ASplash;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;

public class AdxSplash
extends BaseSplash {
    private final String TAG = "AdxSplash";
    private ASplash h;

    public AdxSplash(Context context, Network network) {
        super(context, network);
    }

    protected void onSplashStartLoad() {
        if (this.h != null) {
            this.h.setDefaultAd(this.mIsDefaultAd);
            this.h.loadAd();
        }
        AdLogUtil.Log().d("AdxSplash", "adx splashview load mPlacementId:" + this.mNetwork.codeSeatId);
    }

    protected View getSplash() {
        if (this.h == null && this.mContext != null && this.mContext.get() != null) {
            this.h = new ASplash((Context)this.mContext.get(), this.mNetwork.codeSeatId);
            SspAd.AppId = this.mNetwork.getApplicationId();
            this.h.setAdRequest(new TaRequest.TaRequestBuild().setListener(new AdListener(){

                public void onAdLoaded() {
                    AdxSplash.this.adLoaded();
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdLoaded");
                }

                public void onAdClosed() {
                    AdxSplash.this.adClosed();
                }

                public void onAdShow() {
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdShow");
                    AdxSplash.this.adImpression();
                }

                public void onAdClicked(DownUpPointBean downUpPointBean) {
                    AdxSplash.this.adClicked();
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdClicked");
                }

                public void onError(TaErrorCode taErrorCode) {
                    AdxSplash.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                    AdLogUtil.Log().e("AdxSplash", "adx splashview onError:" + taErrorCode.toString());
                }

                public void onTimeOut() {
                    AdxSplash.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onTimeOut");
                }
            }).build());
            if (this.h != null) {
                this.h.setSkipListener(new OnSkipListener(){

                    public void onClick() {
                        AdxSplash.this.onSkipClick();
                    }

                    public void onTimeEnd() {
                        AdxSplash.this.onTimeReach();
                    }
                });
            }
        }
        return this.h;
    }

    protected void onSplashShow() {
        this.h.show(null);
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.h != null) {
            this.h.destroy();
            this.h = null;
        }
    }
}

