/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adxlibrary.excuter;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.cloud.hisavana.sdk.api.adx.ANative;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.hisavana.adxlibrary.util.NativeInfoTransfer;
import com.hisavana.common.base.BaseNative;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.utils.AdUtil;
import com.transsion.json.Tson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AdxNative
extends BaseNative {
    private String TAG = "AdxNative";
    private ANative f;

    public AdxNative(Context context, Network network, int n) {
        super(context, network, n);
    }

    protected void onNativeAdStartLoad() {
        if (this.f != null) {
            this.f.setDefaultAd(this.mIsDefaultAd);
            this.f.loadAd(this.mRequestId);
        }
        AdLogUtil.Log().d(this.TAG, "adx native load mPlacementId:" + this.mNetwork.codeSeatId + " num:" + this.mAdCount + ",isDefaultAd=" + this.mIsDefaultAd);
    }

    protected void initNative() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.mNatives.clear();
            this.f = new ANative(this.mNetwork.getCodeSeatId());
            this.f.setAdCount(this.mAdCount);
            SspAd.AppId = this.mNetwork.getApplicationId();
            TaRequest taRequest = new TaRequest.TaRequestBuild().setListener(new AdListener(){

                public void onError(TaErrorCode taErrorCode) {
                    AdLogUtil.Log().w(AdxNative.this.TAG, "onAdLoaded error +" + taErrorCode.getErrorCode() + ":::" + taErrorCode.getErrorMessage() + ",isDefaultAd=" + AdxNative.this.mIsDefaultAd);
                    AdxNative.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                }

                public void onAdLoaded(List<TaNativeInfo> list) {
                    AdLogUtil.Log().d(AdxNative.this.TAG, "onAdLoaded multi,isDefaultAd=" + AdxNative.this.mIsDefaultAd);
                    int n = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        TAdNativeInfo tAdNativeInfo = NativeInfoTransfer.a(list.get(i), AdxNative.this.mAdt, AdxNative.this.getTtl(), AdxNative.this);
                        n = AdxNative.this.filter(tAdNativeInfo);
                        if (n == 0) {
                            AdxNative.this.mNatives.add(tAdNativeInfo);
                            continue;
                        }
                        AdUtil.release((TAdNativeInfo)tAdNativeInfo);
                    }
                    if (AdxNative.this.mNatives.size() > 0) {
                        AdxNative.this.a(list);
                        AdxNative.this.adLoaded(AdxNative.this.mNatives);
                    } else {
                        AdxNative.this.adFailedToLoad(new TAdErrorCode(n, "ad filter"));
                        AdLogUtil.Log().w(AdxNative.this.TAG, "ad not pass filter check or no icon or image filter:" + n + ",isDefaultAd=" + AdxNative.this.mIsDefaultAd);
                    }
                }

                public void onTimeOut() {
                    AdxNative.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                }

                public void onAdShow() {
                    super.onAdShow();
                    AdxNative.this.adImpression();
                }

                public void onAdClosed() {
                    super.onAdClosed();
                    AdxNative.this.adClosed();
                }

                public void onAdClicked(DownUpPointBean downUpPointBean) {
                    AdxNative.this.adClicked();
                }
            }).build();
            this.f.setAdRequest(taRequest);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.f != null) {
            this.f.destroy();
            this.f = null;
        }
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, AdNativeInfo adNativeInfo) {
        this.logTrigerShow((TAdNativeInfo)adNativeInfo);
        if (viewGroup != null && this.f != null) {
            this.unregisterView(adNativeInfo);
            try {
                this.f.registerViews(viewGroup, list, (TaNativeInfo)adNativeInfo.getNativeAdWrapper().getNativeAd());
            }
            catch (Throwable throwable) {
                AdLogUtil.Log().e(this.TAG, Log.getStackTraceString((Throwable)throwable));
            }
        }
    }

    public void unregisterView(AdNativeInfo adNativeInfo) {
    }

    public ANative getNativeAd() {
        return this.f;
    }

    private void a(List<TaNativeInfo> list) {
        Object object2;
        ArrayList arrayList = new ArrayList();
        for (Object object2 : list) {
            if (null == object2) continue;
            Bundle bundle = new Bundle();
            Object object3 = object2;
            bundle.putString("ad_title", object3.getTitle());
            bundle.putString("ad_url", "");
            bundle.putString("description", object3.getDescription());
            if (null != object3.getImage()) {
                bundle.putString("image_url", object3.getImage().getImgUrl());
            }
            if (null != object3.getIconImage()) {
                bundle.putString("icon_url", object3.getIconImage().getImgUrl());
            }
            bundle.putString("endcard_url", "");
            bundle.putString("app_name", "");
            bundle.putString("package_name", "");
            bundle.putString("download_url", "");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Set set = bundle.keySet();
            for (String string : set) {
                String string2 = (String)bundle.get(string);
                if (null == string2) continue;
                hashMap.put(string, string2);
            }
            arrayList.add(hashMap);
        }
        Bundle bundle = new Bundle();
        object2 = Tson.toJson(arrayList);
        bundle.putString("native_info_list", (String)object2);
        this.setTrackingBundle(bundle);
    }
}

