/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adxlibrary.excuter;

import android.app.Activity;
import android.content.Context;
import com.cloud.hisavana.sdk.api.adx.innerapi.TInnerInterstitial;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;

public class AdxInterstitia
extends BaseInterstitial {
    private TInnerInterstitial d;

    public AdxInterstitia(Context context, Network network) {
        super(context, network);
    }

    protected void onInterstitialStartLoad() {
        if (this.d != null && !this.d.isLoaded()) {
            this.d.setRequestType(this.requestType);
            this.d.setOfflineAd(this.isOfflineAd);
            this.d.setTriggerId(this.mTriggerId);
            this.d.loadAd(this.mRequestId);
        }
    }

    protected void initInterstitial() {
        if (this.d == null && this.mContext != null && this.mContext.get() != null) {
            this.d = new TInnerInterstitial(this.mNetwork.codeSeatId);
            AdManager.AppId = this.mNetwork.getApplicationId();
            AdListener adListener = new AdListener(){

                public void onError(TaErrorCode taErrorCode) {
                    AdLogUtil.Log().w("AdxInterstitia", "interstitial onError:errorCode:" + taErrorCode.getErrorCode() + ",errorMessage:" + taErrorCode.getErrorMessage() + AdxInterstitia.this.getLogString());
                    AdxInterstitia.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                }

                public void onAdClosed() {
                    AdLogUtil.Log().d("AdxInterstitia", "interstitial is closed" + AdxInterstitia.this.getLogString());
                    AdxInterstitia.this.adClosed();
                }

                public void onAdLoaded() {
                    double d;
                    AdLogUtil.Log().d("AdxInterstitia", "interstitial is Loaded" + AdxInterstitia.this.getLogString());
                    if (AdxInterstitia.this.d != null && (d = AdxInterstitia.this.d.getBidPrice()) > 0.0) {
                        AdxInterstitia.this.setEcpmPrice(d);
                    }
                    AdxInterstitia.this.adLoaded();
                }

                public void onAdClicked(DownUpPointBean downUpPointBean) {
                    AdLogUtil.Log().d("AdxInterstitia", "interstitial is click" + AdxInterstitia.this.getLogString());
                    AdxInterstitia.this.adClicked();
                }

                public void onTimeOut() {
                    AdxInterstitia.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                }

                public void onAdShow() {
                    AdLogUtil.Log().d("AdxInterstitia", "interstitial is onAdShow" + AdxInterstitia.this.getLogString());
                    AdxInterstitia.this.adImpression();
                }
            };
            this.d.setListener(adListener);
        }
    }

    public boolean isExpired() {
        if (this.d != null) {
            return !this.d.isAdValid() || super.isExpired();
        }
        return super.isExpired();
    }

    protected void onInterstitialShow(Activity activity) {
        if (this.d != null) {
            if (this.secondPrice != 0.0) {
                this.d.setSecondPrice(this.secondPrice);
            }
            this.d.show();
        }
    }

    public boolean isLoaded() {
        return this.d != null && this.d.isLoaded();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.d != null) {
            this.d.destroy();
            this.d = null;
        }
        AdLogUtil.Log().d("AdxInterstitia", "destroy" + this.getLogString());
    }

    public boolean isOfflineAd() {
        return this.d != null && this.d.getFillAdType() == 1;
    }
}

