/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import com.cloud.hisavana.sdk.api.adx.TSplashView;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;

public class AdxSplash
extends BaseSplash {
    private final String TAG = "AdxSplash";
    private TSplashView h;

    public AdxSplash(Context context, Network network) {
        super(context, network);
    }

    protected void onSplashStartLoad() {
        if (this.h != null && this.h.getRequest() != null) {
            AdRequest adRequest = this.h.getRequest();
            adRequest.setRequestType(this.requestType);
            adRequest.setTriggerId("hisa-" + this.mTriggerId);
            adRequest.setRequestId("hisa-" + this.mRequestId);
            this.h.setRequest(adRequest);
            this.h.setOfflineAd(this.isOfflineAd);
            this.h.loadAd();
        }
    }

    protected View getSplash() {
        if (this.h == null && this.mContext != null && this.mContext.get() != null) {
            this.h = new TSplashView((Context)this.mContext.get(), this.mNetwork.codeSeatId);
            AdManager.AppId = this.mNetwork.getApplicationId();
            AdListener adListener = new AdListener(){

                public void onAdLoaded() {
                    double d;
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdLoaded" + AdxSplash.this.getLogString());
                    if (AdxSplash.this.h != null && (d = AdxSplash.this.h.getBidPrice()) > 0.0) {
                        AdxSplash.this.setEcpmPrice(d);
                    }
                    AdxSplash.this.adLoaded();
                }

                public void onAdClosed() {
                    AdxSplash.this.adClosed();
                }

                public void onAdShow() {
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdShow" + AdxSplash.this.getLogString());
                    AdxSplash.this.adImpression();
                }

                public void onAdClicked(DownUpPointBean downUpPointBean) {
                    AdxSplash.this.adClicked();
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdClicked" + AdxSplash.this.getLogString());
                }

                public void onError(TaErrorCode taErrorCode) {
                    if (null != taErrorCode) {
                        AdxSplash.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                        AdLogUtil.Log().w("AdxSplash", "adx splashview onError:" + taErrorCode.toString() + AdxSplash.this.getLogString());
                    }
                }

                public void onTimeOut() {
                    AdxSplash.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onTimeOut" + AdxSplash.this.getLogString());
                }
            };
            this.h.setRequest(AdRequest.getBuilder().build());
            this.h.setListener(adListener);
            if (this.h != null) {
                this.h.setSkipListener(new OnSkipListener(){

                    public void onClick() {
                        AdxSplash.this.onSkipClick();
                    }

                    public void onTimeEnd() {
                        AdxSplash.this.onTimeReach();
                    }
                });
            }
        }
        return this.h;
    }

    protected boolean checkNeedAddLogo() {
        return true;
    }

    protected void onSplashShow() {
        if (this.secondPrice != 0.0 && this.h.getRequest() != null) {
            AdRequest adRequest = this.h.getRequest();
            adRequest.setInfo(this.secondPrice);
            this.h.setRequest(adRequest);
        }
        this.h.show();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.h != null) {
            this.h.destroy();
            this.h = null;
        }
        AdLogUtil.Log().d("AdxSplash", "destroy" + this.getLogString());
    }

    public boolean isOfflineAd() {
        return this.h != null && this.h.getFillAdType() == 1;
    }
}

