/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adxlibrary.excuter;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.hisavana.adxlibrary.util.NativeInfoTransfer;
import com.hisavana.common.base.BaseNative;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.AdUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AdxNative
extends BaseNative {
    private String TAG = "AdxNative";
    private TNative f;

    public AdxNative(Context context, Network network, int n) {
        super(context, network, n);
    }

    protected void onNativeAdStartLoad() {
        if (this.f != null && this.f.getRequest() != null) {
            AdRequest adRequest = this.f.getRequest();
            adRequest.setRequestType(this.requestType);
            adRequest.setAdSeatType(this.getAdSeatType());
            adRequest.setTriggerId("hisa-" + this.mTriggerId);
            adRequest.setRequestId("hisa-" + this.mRequestId);
            this.f.setRequest(adRequest);
            this.f.setOfflineAd(this.isOfflineAd);
            this.f.loadAd();
        }
        AdLogUtil.Log().d(this.TAG, "adx native load mPlacementId:" + this.mNetwork != null ? this.mNetwork.getCodeSeatId() : " num:" + this.mAdCount);
    }

    protected void initNative() {
        if (this.mNetwork != null) {
            this.mNatives.clear();
            this.f = new TNative(this.mNetwork.getCodeSeatId());
            this.f.setAdCount(this.mAdCount);
            AdManager.AppId = this.mNetwork.getApplicationId();
            AdListener adListener = new AdListener(){

                public void onError(TaErrorCode taErrorCode) {
                    AdLogUtil.Log().w(AdxNative.this.TAG, "onAdLoaded error +" + taErrorCode.getErrorCode() + ":::" + taErrorCode.getErrorMessage());
                    AdxNative.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                }

                public void onAdLoaded(List<TaNativeInfo> list) {
                    AdLogUtil.Log().d(AdxNative.this.TAG, "onAdLoaded multi");
                    int n = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        TAdNativeInfo tAdNativeInfo = NativeInfoTransfer.a(list.get(i), AdxNative.this.mAdt, AdxNative.this.getTtl(), AdxNative.this);
                        n = AdxNative.this.filter(tAdNativeInfo);
                        if (n == 0) {
                            AdxNative.this.mNatives.add(tAdNativeInfo);
                            continue;
                        }
                        AdUtil.release((TAdNativeInfo)tAdNativeInfo);
                    }
                    if (AdxNative.this.mNatives.size() > 0) {
                        AdxNative.this.a(list);
                        AdxNative.this.adLoaded(AdxNative.this.mNatives);
                    } else {
                        AdxNative.this.adFailedToLoad(new TAdErrorCode(n, "ad filter"));
                        AdLogUtil.Log().w(AdxNative.this.TAG, "ad not pass filter check or no icon or image filter:" + n);
                    }
                }

                public void onTimeOut() {
                    AdxNative.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                }

                public void onAdShow() {
                    super.onAdShow();
                    AdxNative.this.adImpression();
                }

                public void onAdClosed(TaNativeInfo taNativeInfo) {
                    super.onAdClosed();
                    TAdNativeInfo tAdNativeInfo = null;
                    if (AdxNative.this.mNatives != null && !AdxNative.this.mNatives.isEmpty()) {
                        for (TAdNativeInfo tAdNativeInfo2 : AdxNative.this.mNatives) {
                            TaNativeInfo taNativeInfo2 = (TaNativeInfo)tAdNativeInfo2.getNativeAdWrapper().getNativeAd();
                            if (taNativeInfo2 != taNativeInfo) continue;
                            tAdNativeInfo = tAdNativeInfo2;
                            break;
                        }
                    }
                    AdxNative.this.adClosed(tAdNativeInfo);
                }

                public void onAdClicked() {
                    AdxNative.this.adClicked();
                }
            };
            this.f.setRequest(AdRequest.getBuilder().build());
            this.f.setListener(adListener);
            this.f.setPlacementId(this.mNetwork.getCodeSeatId());
        }
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.f != null) {
            this.f.destroy();
            this.f = null;
        }
        AdLogUtil.Log().d(this.TAG, "destroy" + this.getLogString());
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, AdNativeInfo adNativeInfo) {
        this.logTrigerShow((TAdNativeInfo)adNativeInfo);
        if (viewGroup != null && this.f != null) {
            this.unregisterView(adNativeInfo);
            try {
                TaNativeInfo taNativeInfo = (TaNativeInfo)adNativeInfo.getNativeAdWrapper().getNativeAd();
                double d = adNativeInfo.getSecondPrice();
                if (d != 0.0) {
                    taNativeInfo.setSecondPrice(d);
                }
                this.f.registerViews(viewGroup, list, taNativeInfo);
            }
            catch (Throwable throwable) {
                AdLogUtil.Log().e(this.TAG, Log.getStackTraceString((Throwable)throwable));
            }
        }
    }

    public void unregisterView(AdNativeInfo adNativeInfo) {
    }

    public TNative getNativeAd() {
        return this.f;
    }

    private void a(List<TaNativeInfo> list) {
        Object object2;
        ArrayList arrayList = new ArrayList();
        for (Object object2 : list) {
            if (null == object2) continue;
            Bundle bundle = new Bundle();
            Object object3 = object2;
            bundle.putString("ad_title", object3.getTitle());
            bundle.putString("ad_url", "");
            bundle.putString("description", object3.getDescription());
            if (null != object3.getImage()) {
                bundle.putString("image_url", object3.getImage().getImgUrl());
            }
            if (null != object3.getIconImage()) {
                bundle.putString("icon_url", object3.getIconImage().getImgUrl());
            }
            bundle.putString("endcard_url", "");
            bundle.putString("app_name", "");
            bundle.putString("package_name", "");
            bundle.putString("download_url", "");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Set set = bundle.keySet();
            for (String string : set) {
                String string2 = (String)bundle.get(string);
                if (null == string2) continue;
                hashMap.put(string, string2);
            }
            arrayList.add(hashMap);
        }
        Bundle bundle = new Bundle();
        object2 = GsonUtil.toJson(arrayList);
        bundle.putString("native_info_list", (String)object2);
        this.setTrackingBundle(bundle);
    }

    public boolean isOfflineAd() {
        return this.mNatives != null && this.mNatives.size() > 0 && ((TAdNativeInfo)this.mNatives.get(0)).isOfflineAd();
    }
}

