/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import com.cloud.hisavana.sdk.api.adx.TSplash;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdxSplash
extends BaseSplash {
    private final String TAG = "AdxSplash";
    private TSplash i;

    public AdxSplash(Context context, Network network) {
        super(context, network);
    }

    protected void onSplashStartLoad() {
        if (this.i != null && this.i.getRequest() != null) {
            AdRequest adRequest = this.i.getRequest();
            adRequest.setRequestType(this.requestType);
            adRequest.setTriggerId("hisa-" + this.mTriggerId);
            adRequest.setRequestId("hisa-" + this.mRequestId);
            adRequest.setPrior(this.getSupportHisavanaFlag() >= 2);
            this.i.setRequest(adRequest);
            this.i.setOfflineAd(this.isOfflineAd);
            this.i.loadAd();
        }
    }

    protected View getSplash() {
        if (this.i == null && this.mContext != null && this.mContext.get() != null) {
            this.i = new TSplash((Context)this.mContext.get(), this.mNetwork.getCodeSeatId());
            AdManager.AppId = this.mNetwork.getApplicationId();
            AdListener adListener = new AdListener(){

                public void onAdLoaded() {
                    double d;
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdLoaded" + AdxSplash.this.getLogString());
                    if (AdxSplash.this.i != null && (d = AdxSplash.this.i.getBidPrice()) > 0.0) {
                        AdxSplash.this.setEcpmPrice(d);
                    }
                    AdxSplash.this.adLoaded();
                }

                public void onAdClosed() {
                    AdxSplash.this.adClosed();
                }

                public void onAdShow() {
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdShow" + AdxSplash.this.getLogString());
                    AdxSplash.this.adImpression(null);
                }

                public void onAdClicked() {
                    AdxSplash.this.adClicked(null);
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdClicked" + AdxSplash.this.getLogString());
                }

                public void onError(TaErrorCode taErrorCode) {
                    if (null != taErrorCode) {
                        AdxSplash.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                        AdLogUtil.Log().w("AdxSplash", "adx splashview onError:" + taErrorCode.toString() + AdxSplash.this.getLogString());
                    }
                }

                public void onTimeOut() {
                    AdxSplash.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onTimeOut" + AdxSplash.this.getLogString());
                }
            };
            this.i.setRequest(AdRequest.getBuilder().build());
            this.i.setListener(adListener);
            if (this.i != null) {
                this.i.setSkipListener(new OnSkipListener(){

                    public void onClick() {
                        AdxSplash.this.onSkipClick();
                    }

                    public void onTimeEnd() {
                        AdxSplash.this.onTimeReach();
                    }
                });
            }
        }
        if (CoreUtil.getContext() != null) {
            return new View(CoreUtil.getContext().getApplicationContext());
        }
        return null;
    }

    protected boolean checkNeedAddLogo() {
        return true;
    }

    protected void onSplashShow() {
        if (this.i == null) {
            AdLogUtil.Log().d("AdxSplash", "show splash failed");
            return;
        }
        if (this.secondPrice != 0.0 && this.i != null && this.i.getRequest() != null) {
            AdRequest adRequest = this.i.getRequest();
            adRequest.setInfo(this.secondPrice);
            this.i.setRequest(adRequest);
        }
        if (this.i != null) {
            this.i.show();
        }
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.i != null) {
            this.i.destroy();
            this.i = null;
        }
        AdLogUtil.Log().d("AdxSplash", "destroy" + this.getLogString());
    }

    public boolean isAdxAd() {
        if (this.i != null) {
            return this.i.getAdSource() == 2;
        }
        return false;
    }

    public boolean isEwAd() {
        if (this.i != null) {
            return this.i.getAdSource() == 1;
        }
        return false;
    }

    public boolean isOfflineAd() {
        return this.i != null && this.i.getFillAdType() == 1;
    }
}

