/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import com.cloud.hisavana.sdk.api.adx.TBannerView;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdxBanner
extends BaseBanner<TBannerView> {
    private TBannerView a;

    public AdxBanner(Context context, Network network, int n) {
        super(context, network);
        AdLogUtil.Log().d("AdxBanner", "bannerSize:=" + n + this.getLogString());
    }

    protected TBannerView a() {
        AdLogUtil.Log().d("AdxBanner", "getBanner " + this.requestType);
        if (this.a == null && this.mNetwork != null) {
            AdManager.AppId = this.mNetwork.getApplicationId();
            this.a = new TBannerView(CoreUtil.getContext(), this.mNetwork.getCodeSeatId());
            AdListener adListener = new AdListener(){

                public void onError(TaErrorCode taErrorCode) {
                    AdLogUtil.Log().w("AdxBanner", "banner is Load error:" + taErrorCode.getErrorCode() + " msg:" + taErrorCode.getErrorMessage() + AdxBanner.this.getLogString());
                    AdxBanner.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                }

                public void onAdLoaded() {
                    double d;
                    AdLogUtil.Log().d("AdxBanner", "banner is Loaded" + AdxBanner.this.getLogString());
                    if (AdxBanner.this.a != null && (d = AdxBanner.this.a.getBidPrice()) > 0.0) {
                        AdxBanner.this.setEcpmPrice(d);
                    }
                    AdxBanner.this.adLoaded();
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d("AdxBanner", "banner is click" + AdxBanner.this.getLogString());
                    AdxBanner.this.adClicked(null);
                }

                public void onAdClosed(TBannerView tBannerView) {
                    AdLogUtil.Log().d("AdxBanner", "banner onAdClosed" + AdxBanner.this.getLogString());
                    AdxBanner.this.adClosed();
                }

                public void onTimeOut() {
                    AdLogUtil.Log().d("AdxBanner", "banner onTimeOut" + AdxBanner.this.getLogString());
                    AdxBanner.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                }

                public void onAdShow() {
                    AdLogUtil.Log().d("AdxBanner", "banner onAdShow" + AdxBanner.this.getLogString());
                    AdxBanner.this.adImpression(null);
                }
            };
            this.a.setRequest(AdRequest.getBuilder().build());
            this.a.setListener(adListener);
            this.a.setPlacementId(this.mNetwork.getCodeSeatId());
        }
        return this.a;
    }

    protected void onBannerLoad() {
        if (this.a != null && this.a.getRequest() != null) {
            AdLogUtil.Log().d("AdxBanner", "onBannerLoad " + this.a.getRequest());
            AdRequest adRequest = this.a.getRequest();
            adRequest.setRequestType(this.requestType);
            adRequest.setTriggerId("hisa-" + this.mTriggerId);
            adRequest.setRequestId("hisa-" + this.mRequestId);
            adRequest.setPrior(this.getSupportHisavanaFlag() >= 2);
            this.a.setRequest(adRequest);
            this.a.setOfflineAd(this.isOfflineAd);
            this.a.loadAd();
        }
    }

    protected void showBanner() {
        if (this.a != null) {
            if (this.secondPrice != 0.0 && this.a.getRequest() != null) {
                AdRequest adRequest = this.a.getRequest();
                adRequest.setInfo(this.secondPrice);
                this.a.setRequest(adRequest);
            }
            this.a.show();
        } else {
            this.onAdShowError(TAdErrorCode.ERROR_AD_IS_NULL);
            AdLogUtil.Log().e("AdxBanner", "showBanner show error");
        }
    }

    protected void onBannerDestroy() {
        if (this.a != null) {
            this.a.destroy();
            this.a = null;
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("AdxBanner", "destroy" + this.getLogString());
    }

    public boolean isAdxAd() {
        if (this.a != null) {
            return this.a.getAdSource() == 2;
        }
        return false;
    }

    public boolean isEwAd() {
        if (this.a != null) {
            return this.a.getAdSource() == 1;
        }
        return false;
    }

    public boolean isOfflineAd() {
        return this.a != null && this.a.getFillAdType() == 1;
    }

    protected /* synthetic */ View getBanner() {
        return this.a();
    }
}

