/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import com.cloud.hisavana.sdk.api.adx.TSplash;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdxSplash
extends BaseSplash {
    private TSplash h;

    public AdxSplash(Context context, Network network) {
        super(context, network);
    }

    protected void onSplashStartLoad() {
        if (this.h != null && this.h.getRequest() != null) {
            AdRequest adRequest = this.h.getRequest();
            adRequest.setRequestType(this.requestType);
            adRequest.setTriggerId("hisa-" + this.mTriggerId);
            adRequest.setRequestId("hisa-" + this.mRequestId);
            adRequest.setPrior(this.getSupportHisavanaFlag() >= 2);
            this.h.setRequest(adRequest);
            this.h.setOfflineAd(this.isOfflineAd);
            this.h.loadAd();
        }
    }

    protected View getSplash() {
        if (this.h == null) {
            this.h = new TSplash(CoreUtil.getContext(), this.mNetwork.getCodeSeatId());
            AdManager.AppId = this.mNetwork.getApplicationId();
            AdListener adListener = new AdListener(){

                public void onAdLoaded() {
                    double d;
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdLoaded" + AdxSplash.this.getLogString());
                    if (AdxSplash.this.h != null && (d = AdxSplash.this.h.getBidPrice()) > 0.0) {
                        AdxSplash.this.setEcpmPrice(d);
                    }
                    AdxSplash.this.adLoaded();
                }

                public void onAdClosed() {
                    AdLogUtil.Log().d("AdxSplash", "adx onAdClosed " + AdxSplash.this.getLogString());
                    AdxSplash.this.adClosed();
                }

                public void onAdShow() {
                    AdLogUtil.Log().d("AdxSplash", "adx onAdShow" + AdxSplash.this.getLogString());
                    AdxSplash.this.adImpression(null);
                }

                public void onAdClicked() {
                    AdxSplash.this.adClicked(null);
                    AdLogUtil.Log().d("AdxSplash", "adx onAdClicked" + AdxSplash.this.getLogString());
                }

                public void onError(TaErrorCode taErrorCode) {
                    if (null != taErrorCode) {
                        AdxSplash.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                        AdLogUtil.Log().w("AdxSplash", "adx onError:" + taErrorCode.toString() + AdxSplash.this.getLogString());
                    }
                }

                public void onTimeOut() {
                    AdxSplash.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                    AdLogUtil.Log().d("AdxSplash", "adx onTimeOut" + AdxSplash.this.getLogString());
                }
            };
            this.h.setRequest(AdRequest.getBuilder().build());
            this.h.setListener(adListener);
            this.h.setSkipListener(new OnSkipListener(){

                public void onClick() {
                    AdLogUtil.Log().d("AdxSplash", "onClick click skip btn");
                    AdxSplash.this.onSkipClick();
                }

                public void onTimeEnd() {
                    AdLogUtil.Log().d("AdxSplash", "onTimeEnd,splash timeout");
                    AdxSplash.this.onTimeReach();
                }
            });
        }
        if (CoreUtil.getContext() != null) {
            return new View(CoreUtil.getContext().getApplicationContext());
        }
        return null;
    }

    protected boolean checkNeedAddLogo() {
        return true;
    }

    protected void onSplashShow() {
        if (this.h == null) {
            AdLogUtil.Log().d("AdxSplash", "show splash failed");
            this.onAdShowError(TAdErrorCode.ERROR_AD_IS_NULL);
            return;
        }
        if (this.secondPrice != 0.0 && this.h.getRequest() != null) {
            AdRequest adRequest = this.h.getRequest();
            adRequest.setInfo(this.secondPrice);
            this.h.setRequest(adRequest);
        }
        this.h.setLogoLayout(this.getLogoLayout());
        this.h.show();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.h != null) {
            this.h.destroy();
            this.h = null;
        }
        AdLogUtil.Log().d("AdxSplash", "destroy" + this.getLogString());
    }

    public boolean isAdxAd() {
        if (this.h != null) {
            return this.h.getAdSource() == 2;
        }
        return false;
    }

    public boolean isEwAd() {
        if (this.h != null) {
            return this.h.getAdSource() == 1;
        }
        return false;
    }

    public boolean isOfflineAd() {
        return this.h != null && this.h.getFillAdType() == 1;
    }
}

