/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.load;

import android.text.TextUtils;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.AdModule;
import com.unity3d.services.ads.operation.load.ILoadModule;
import com.unity3d.services.ads.operation.load.ILoadOperation;
import com.unity3d.services.ads.operation.load.LoadModuleDecoratorInitializationBuffer;
import com.unity3d.services.ads.operation.load.LoadModuleDecoratorTimeout;
import com.unity3d.services.ads.operation.load.LoadOperation;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.core.configuration.InitializationNotificationCenter;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.metrics.ISDKMetricSender;
import com.unity3d.services.core.request.metrics.SDKMetricEvents;
import com.unity3d.services.core.request.metrics.SDKMetricSender;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.invocation.IWebViewBridgeInvocationCallback;
import com.unity3d.services.core.webview.bridge.invocation.WebViewBridgeInvocation;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LoadModule
extends AdModule<ILoadOperation, LoadOperationState>
implements ILoadModule {
    private static ILoadModule _instance;
    private static String errorMsgInternalCommunicationFailure;
    private static String errorMsgInternalCommunicationTimeout;
    private static String errorMsgPlacementIdNull;
    private static String errorMsgFailedToCreateLoadRequest;

    public static ILoadModule getInstance() {
        if (_instance == null) {
            LoadModule loadModule = new LoadModule(new SDKMetricSender());
            LoadModuleDecoratorInitializationBuffer bufferedLoadModule = new LoadModuleDecoratorInitializationBuffer(loadModule, InitializationNotificationCenter.getInstance());
            LoadModuleDecoratorTimeout timedLoadModule = new LoadModuleDecoratorTimeout(bufferedLoadModule);
            _instance = timedLoadModule;
        }
        return _instance;
    }

    public LoadModule(ISDKMetricSender sdkMetricSender) {
        super(sdkMetricSender);
    }

    @Override
    public void executeAdOperation(IWebViewBridgeInvoker webViewBridgeInvoker, final LoadOperationState state) {
        if (TextUtils.isEmpty((CharSequence)state.placementId)) {
            this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INVALID_ARGUMENT, errorMsgPlacementIdNull);
            return;
        }
        LoadOperation loadOperation = new LoadOperation(state, new WebViewBridgeInvocation(this._executorService, webViewBridgeInvoker, new IWebViewBridgeInvocationCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(String message, CallbackStatus callbackStatus) {
                LoadModule.this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgInternalCommunicationFailure);
                final String cbs = callbackStatus == null ? "invocationFailure" : callbackStatus.toString();
                LoadModule.this._sdkMetricSender.sendSDKMetricEventWithTag(SDKMetricEvents.native_load_callback_error, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("cbs", cbs);
                    }
                });
                LoadModule.this.remove(state.id);
            }

            @Override
            public void onTimeout() {
                LoadModule.this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgInternalCommunicationTimeout);
                LoadModule.this.getMetricSender().sendSDKMetricEvent(SDKMetricEvents.native_load_callback_timeout);
                LoadModule.this.remove(state.id);
            }
        }));
        JSONObject parameters = new JSONObject();
        JSONObject options = new JSONObject();
        try {
            options.put("headerBiddingOptions", (Object)state.loadOptions.getData());
            parameters.put("options", (Object)options);
            parameters.put("listenerId", (Object)loadOperation.getId());
            parameters.put("placementId", (Object)state.placementId);
            parameters.put("time", Device.getElapsedRealtime());
        }
        catch (JSONException e) {
            this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgFailedToCreateLoadRequest);
            return;
        }
        catch (NullPointerException e) {
            this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgFailedToCreateLoadRequest);
            return;
        }
        this.set(loadOperation);
        loadOperation.invoke(state.configuration.getWebViewBridgeTimeout(), parameters);
    }

    @Override
    public void onUnityAdsAdLoaded(String operationId) {
        ILoadOperation loadOperation = (ILoadOperation)this.get(operationId);
        if (loadOperation == null || loadOperation.getLoadOperationState() == null) {
            return;
        }
        loadOperation.onUnityAdsAdLoaded(loadOperation.getLoadOperationState().placementId);
        this.remove(operationId);
    }

    @Override
    public void onUnityAdsFailedToLoad(String operationId, UnityAds.UnityAdsLoadError error, String message) {
        ILoadOperation loadOperation = (ILoadOperation)this.get(operationId);
        if (loadOperation == null || loadOperation.getLoadOperationState() == null) {
            return;
        }
        loadOperation.onUnityAdsFailedToLoad(loadOperation.getLoadOperationState().placementId, error, message);
        this.remove(operationId);
    }

    private void sendOnUnityAdsFailedToLoad(final LoadOperationState state, final UnityAds.UnityAdsLoadError error, final String message) {
        if (state == null || state.listener == null) {
            return;
        }
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                state.onUnityAdsFailedToLoad(error, message);
            }
        });
    }

    static {
        errorMsgInternalCommunicationFailure = "[UnityAds] Internal communication failure";
        errorMsgInternalCommunicationTimeout = "[UnityAds] Internal communication timeout";
        errorMsgPlacementIdNull = "[UnityAds] Placement ID cannot be null";
        errorMsgFailedToCreateLoadRequest = "[UnityAds] Failed to create load request";
    }
}

