/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import com.unity3d.services.ads.token.AsyncTokenStorage;
import com.unity3d.services.ads.token.TokenEvent;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.device.TokenType;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;

public class TokenStorage {
    private static final Object _lock = new Object();
    private static ConcurrentLinkedQueue<String> _queue;
    private static int _accessCounter;
    private static boolean _peekMode;
    private static String _initToken;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTokens(JSONArray tokens) throws JSONException {
        boolean shouldTriggerEvent;
        Object object = _lock;
        synchronized (object) {
            _queue = new ConcurrentLinkedQueue();
            _accessCounter = 0;
            for (int i = 0; i < tokens.length(); ++i) {
                _queue.add(tokens.getString(i));
            }
            shouldTriggerEvent = !_queue.isEmpty();
        }
        if (shouldTriggerEvent) {
            TokenStorage.triggerTokenAvailable(false);
            AsyncTokenStorage.getInstance().onTokenAvailable(TokenType.TOKEN_REMOTE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendTokens(JSONArray tokens) throws JSONException {
        boolean shouldTriggerEvent;
        Object object = _lock;
        synchronized (object) {
            if (_queue == null) {
                _queue = new ConcurrentLinkedQueue();
                _accessCounter = 0;
            }
            for (int i = 0; i < tokens.length(); ++i) {
                _queue.add(tokens.getString(i));
            }
            shouldTriggerEvent = !_queue.isEmpty();
        }
        if (shouldTriggerEvent) {
            TokenStorage.triggerTokenAvailable(false);
            AsyncTokenStorage.getInstance().onTokenAvailable(TokenType.TOKEN_REMOTE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTokens() {
        Object object = _lock;
        synchronized (object) {
            _queue = null;
            _accessCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken() {
        Object object = _lock;
        synchronized (object) {
            if (_queue == null) {
                return _initToken;
            }
            if (_queue.isEmpty()) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.QUEUE_EMPTY, new Object[0]);
                return null;
            }
            if (_peekMode) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, _accessCounter++);
                return _queue.peek();
            }
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, _accessCounter++);
            return _queue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPeekMode(boolean mode) {
        Object object = _lock;
        synchronized (object) {
            _peekMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitToken(String value) {
        boolean shouldTriggerEvent;
        Object object = _lock;
        synchronized (object) {
            _initToken = value;
            shouldTriggerEvent = _initToken != null;
        }
        if (shouldTriggerEvent) {
            AsyncTokenStorage.getInstance().onTokenAvailable(TokenType.TOKEN_REMOTE);
            TokenStorage.triggerTokenAvailable(true);
        }
    }

    private static void triggerTokenAvailable(Boolean withConfig) {
        InitializeEventsMetricSender.getInstance().sdkTokenDidBecomeAvailableWithConfig(withConfig);
    }

    static {
        _accessCounter = 0;
        _peekMode = false;
        _initToken = null;
    }
}

