/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.device.reader.IDeviceInfoReader;
import com.unity3d.services.core.device.reader.pii.DataSelectorResult;
import com.unity3d.services.core.device.reader.pii.PiiDataProvider;
import com.unity3d.services.core.device.reader.pii.PiiDataSelector;
import com.unity3d.services.core.device.reader.pii.PiiDecisionData;
import java.util.HashMap;
import java.util.Map;

public class DeviceInfoReaderWithPII
implements IDeviceInfoReader {
    private IDeviceInfoReader _deviceInfoReader;
    private PiiDataProvider _piiDataProvider;
    private PiiDataSelector _piiDataSelector;

    public DeviceInfoReaderWithPII(IDeviceInfoReader deviceInfoReader, PiiDataSelector piiDataSelector, PiiDataProvider piiDataProvider) {
        this._deviceInfoReader = deviceInfoReader;
        this._piiDataSelector = piiDataSelector;
        this._piiDataProvider = piiDataProvider;
    }

    @Override
    public Map<String, Object> getDeviceInfoData() {
        Map<String, Object> originalData = this._deviceInfoReader.getDeviceInfoData();
        PiiDecisionData piiDecisionData = this._piiDataSelector.whatToDoWithPII();
        DataSelectorResult dataSelectorResult = piiDecisionData.getResultType();
        switch (dataSelectorResult) {
            case INCLUDE: {
                originalData.putAll(this.getPiiAttributesFromStorage(piiDecisionData));
                break;
            }
            case UPDATE: {
                originalData.putAll(this.getPiiAttributesFromDevice(piiDecisionData));
                break;
            }
            case EXCLUDE: {
                return originalData;
            }
        }
        return originalData;
    }

    private Map<String, Object> getPiiAttributesFromStorage(PiiDecisionData decisionData) {
        return decisionData.getAttributes();
    }

    private Map<String, Object> getPiiAttributesFromDevice(PiiDecisionData decisionData) {
        HashMap<String, Object> piiData = new HashMap<String, Object>();
        String advertisingId = this._piiDataProvider.getAdvertisingTrackingId();
        if (advertisingId != null) {
            piiData.put("unifiedconfig.pii.advertisingTrackingId", advertisingId);
        }
        if (decisionData.getUserNonBehavioralFlag() != null) {
            piiData.put("user.nonBehavioral", decisionData.getUserNonBehavioralFlag());
        }
        return piiData;
    }
}

