/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request.metrics;

import android.text.TextUtils;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.WebRequest;
import com.unity3d.services.core.request.metrics.ISDKMetrics;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.MetricCommonTags;
import com.unity3d.services.core.request.metrics.MetricsContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class MetricSender
implements ISDKMetrics {
    private final MetricCommonTags _commonTags;
    private final String _metricEndpoint;
    private final ExecutorService _executorService;

    public MetricSender(String url) {
        this._metricEndpoint = url;
        this._executorService = Executors.newSingleThreadExecutor();
        this._commonTags = new MetricCommonTags(Device.getNetworkCountryISO(), "android", SdkProperties.getVersionName(), Device.getOsVersion());
    }

    @Override
    public void sendEvent(String event) {
        this.sendEvent(event, null);
    }

    @Override
    public void sendEvent(String event, Map<String, String> tags) {
        if (event == null || event.isEmpty()) {
            DeviceLog.debug("Metric event not sent due to being null or empty: " + event);
            return;
        }
        this.sendEvent(event, null, tags);
    }

    @Override
    public void sendEvent(String event, String value, Map<String, String> tags) {
        this.sendMetrics(new ArrayList<Metric>(Collections.singletonList(new Metric(event, value, tags))));
    }

    @Override
    public void sendMetric(Metric metric) {
        this.sendMetrics(new ArrayList<Metric>(Collections.singletonList(metric)));
    }

    @Override
    public void sendMetrics(final List<Metric> metrics) {
        if (metrics == null || metrics.size() <= 0) {
            DeviceLog.debug("Metrics event not send due to being null or empty");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this._metricEndpoint)) {
            DeviceLog.debug("Metrics: " + metrics + " was not sent to null or empty endpoint: " + this._metricEndpoint);
            return;
        }
        if (this._executorService.isShutdown()) {
            DeviceLog.debug("Metrics " + metrics + " was not sent due to misconfiguration");
            return;
        }
        this._executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean is2XXResponseCode;
                    MetricsContainer container = new MetricsContainer(MetricSender.this._commonTags, metrics);
                    String postBody = new JSONObject(container.asMap()).toString();
                    WebRequest request = new WebRequest(MetricSender.this._metricEndpoint, "POST", null);
                    request.setBody(postBody);
                    request.makeRequest();
                    boolean bl = is2XXResponseCode = request.getResponseCode() / 100 == 2;
                    if (is2XXResponseCode) {
                        DeviceLog.debug("Metric " + metrics + " sent to " + MetricSender.this._metricEndpoint);
                    } else {
                        DeviceLog.debug("Metric " + metrics + " failed to send with response code: " + request.getResponseCode());
                    }
                }
                catch (Exception e) {
                    DeviceLog.debug("Metric " + metrics + " failed to send from exception: " + e.getMessage());
                }
            }
        });
    }

    @Override
    public String getMetricEndPoint() {
        return this._metricEndpoint;
    }

    void shutdown() {
        this._executorService.shutdown();
    }
}

