/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.core.api;

import com.unity3d.services.ads.gmascar.handlers.WebViewErrorHandler;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import com.unity3d.services.store.StoreError;
import com.unity3d.services.store.StoreEvent;
import com.unity3d.services.store.StoreMonitor;
import com.unity3d.services.store.core.StoreExceptionHandler;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;

public class Store {
    private static final StoreExceptionHandler storeExceptionHandler = new StoreExceptionHandler(new WebViewErrorHandler());

    @WebViewExposed
    public static void initialize(WebViewCallback callback) {
        try {
            StoreMonitor.initialize(storeExceptionHandler);
            callback.invoke(new Object[0]);
        }
        catch (Exception e) {
            callback.error(StoreError.UNKNOWN_ERROR, e.getMessage(), e.getClass().getName());
        }
    }

    @WebViewExposed
    public static void startPurchaseTracking(JSONArray purchaseTypes, WebViewCallback callback) {
        if (!StoreMonitor.isInitialized()) {
            callback.error(StoreError.NOT_INITIALIZED, new Object[0]);
            return;
        }
        ArrayList<String> purchaseTypeList = new ArrayList<String>();
        try {
            for (int i = 0; i < purchaseTypes.length(); ++i) {
                purchaseTypeList.add(purchaseTypes.getString(i));
            }
        }
        catch (JSONException e) {
            callback.error(StoreError.JSON_ERROR, e.getMessage());
            return;
        }
        StoreMonitor.startPurchaseTracking(purchaseTypeList);
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void stopPurchaseTracking(WebViewCallback callback) {
        if (!StoreMonitor.isInitialized()) {
            callback.error(StoreError.NOT_INITIALIZED, new Object[0]);
            return;
        }
        StoreMonitor.stopPurchaseTracking();
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void isFeatureSupported(final Integer operationId, final String purchaseType, WebViewCallback callback) {
        if (!StoreMonitor.isInitialized()) {
            callback.error(StoreError.NOT_INITIALIZED, new Object[0]);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                StoreMonitor.isFeatureSupported(operationId, purchaseType);
            }
        }).start();
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getPurchases(Integer operationId, String purchaseType, WebViewCallback callback) {
        if (!StoreMonitor.isInitialized()) {
            callback.error(StoreError.NOT_INITIALIZED, new Object[0]);
            return;
        }
        StoreMonitor.getPurchases(operationId, purchaseType);
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getPurchaseHistory(Integer operationId, String purchaseType, Integer maxPurchases, WebViewCallback callback) {
        if (!StoreMonitor.isInitialized()) {
            callback.error(StoreError.NOT_INITIALIZED, new Object[0]);
            return;
        }
        StoreMonitor.getPurchaseHistory(operationId, purchaseType, maxPurchases);
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getSkuDetails(Integer operationId, String purchaseType, JSONArray skuList, WebViewCallback callback) {
        if (!StoreMonitor.isInitialized()) {
            callback.error(StoreError.NOT_INITIALIZED, new Object[0]);
            return;
        }
        try {
            ArrayList<String> skuArray = new ArrayList<String>();
            for (int i = 0; i < skuList.length(); ++i) {
                skuArray.add(skuList.getString(i));
            }
            StoreMonitor.getSkuDetails(operationId, purchaseType, skuArray);
        }
        catch (JSONException exception) {
            storeExceptionHandler.handleStoreException(StoreEvent.SKU_DETAILS_LIST_REQUEST_ERROR, operationId, (Exception)((Object)exception));
        }
        callback.invoke(new Object[0]);
    }
}

