/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.unity.excuter;

import android.content.Context;
import android.view.View;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;

public class UnityBanner
extends BaseBanner {
    private BannerView a;
    private int b;

    public UnityBanner(Context context, Network network, int n) {
        super(context, network);
        this.b = n;
        AdLogUtil.Log().d("unity_log", "bannerSize:=" + n + this.getLogString());
    }

    protected void onBannerDestroy() {
        if (this.a != null) {
            this.a.destroy();
            this.a = null;
        }
    }

    protected View getBanner() {
        if (null == this.a && null != this.mNetwork && LifecycleUtil.getMainActivity() != null) {
            UnityBannerSize unityBannerSize;
            switch (this.b) {
                case 0: {
                    unityBannerSize = new UnityBannerSize(320, 50);
                    break;
                }
                case 1: 
                case 3: {
                    unityBannerSize = new UnityBannerSize(320, 90);
                    break;
                }
                case 2: {
                    unityBannerSize = new UnityBannerSize(320, 250);
                    break;
                }
                default: {
                    unityBannerSize = new UnityBannerSize(320, 50);
                }
            }
            this.a = new BannerView(LifecycleUtil.getMainActivity(), this.mNetwork.codeSeatId, unityBannerSize);
            BannerView.IListener iListener = new BannerView.IListener(){

                public void onBannerLoaded(BannerView bannerView) {
                    AdLogUtil.Log().d("unity_log", "onUnityAdsFailedToLoad");
                    UnityBanner.this.adLoaded();
                }

                public void onBannerFailedToLoad(BannerView bannerView, BannerErrorInfo bannerErrorInfo) {
                    AdLogUtil.Log().d("unity_log", "Unity Ads failed to show ad for " + bannerView.getPlacementId() + " with error: [" + bannerErrorInfo.errorCode + "] " + bannerErrorInfo.errorMessage + UnityBanner.this.getLogString());
                    UnityBanner.this.adFailedToLoad(new TAdErrorCode(1035, "Unity Ads failed to load ad for " + bannerView.getPlacementId() + " with error: [" + bannerErrorInfo.errorCode + "] " + bannerErrorInfo.errorMessage));
                }

                public void onBannerClick(BannerView bannerView) {
                    AdLogUtil.Log().d("unity_log", "onUnityAdsShowClick: " + bannerView.getPlacementId() + UnityBanner.this.getLogString());
                    UnityBanner.this.adClicked();
                }

                public void onBannerLeftApplication(BannerView bannerView) {
                }
            };
            this.a.setListener(iListener);
        }
        return this.a;
    }

    protected void onBannerLoad() {
        if (UnityAds.isInitialized()) {
            this.a.load();
        } else {
            this.adFailedToLoad(new TAdErrorCode(1035, "Unity Ads failed to load ad error with : UnityAds.isInitialized() " + UnityAds.isInitialized()));
            AdLogUtil.Log().d("unity_log", "UnityAds.isInitialized()" + UnityAds.isInitialized());
        }
    }

    protected void showBanner() {
        if (this.a != null) {
            this.a.setVisibility(0);
            this.adImpression();
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("unity_log", "destroy" + this.getLogString());
    }
}

