/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.unity.excuter;

import android.content.Context;
import android.view.View;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.unity.check.ExistsCheck;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;

public class UnityBanner
extends BaseBanner {
    private BannerView a;
    private final int b;

    public UnityBanner(Context context, Network network, int mBannerSize) {
        super(context, network);
        this.b = mBannerSize;
        AdLogUtil.Log().d("unity_log", "bannerSize:=" + mBannerSize + this.getLogString());
    }

    protected void onBannerDestroy() {
        if (this.a != null) {
            this.a.destroy();
            this.a = null;
        }
    }

    protected View getBanner() {
        if (null == this.a && null != this.mNetwork && LifecycleUtil.getMainActivity() != null) {
            UnityBannerSize unityBannerSize;
            switch (this.b) {
                case 0: {
                    unityBannerSize = new UnityBannerSize(320, 50);
                    break;
                }
                case 1: 
                case 3: {
                    unityBannerSize = new UnityBannerSize(320, 90);
                    break;
                }
                case 2: {
                    unityBannerSize = new UnityBannerSize(320, 250);
                    break;
                }
                default: {
                    unityBannerSize = new UnityBannerSize(320, 50);
                }
            }
            this.a = new BannerView(LifecycleUtil.getMainActivity(), this.mNetwork.getCodeSeatId(), unityBannerSize);
            BannerView.IListener iListener = new BannerView.IListener(){

                public void onBannerLoaded(BannerView bannerAdView) {
                    AdLogUtil.Log().d("unity_log", "onBannerLoaded");
                    UnityBanner.this.adLoaded();
                }

                public void onBannerFailedToLoad(BannerView bannerAdView, BannerErrorInfo errorInfo) {
                    if (bannerAdView != null && errorInfo != null) {
                        AdLogUtil.Log().e("unity_log", "onBannerFailedToLoad bannerAdView " + bannerAdView + " errorInfo " + errorInfo.errorMessage);
                        AdLogUtil.Log().d("unity_log", "Unity Ads failed to show ad for " + bannerAdView.getPlacementId() + " with error: [" + errorInfo.errorCode + "] " + errorInfo.errorMessage + UnityBanner.this.getLogString());
                        UnityBanner.this.adFailedToLoad(new TAdErrorCode(1035, "Unity Ads failed to load ad for " + bannerAdView.getPlacementId() + " with error: [" + errorInfo.errorCode + "] " + errorInfo.errorMessage));
                    } else {
                        UnityBanner.this.adFailedToLoad(new TAdErrorCode(1035, "Unity Ads failed to load ad for "));
                    }
                }

                public void onBannerClick(BannerView bannerAdView) {
                    if (bannerAdView != null) {
                        AdLogUtil.Log().d("unity_log", "onUnityAdsShowClick: " + bannerAdView.getPlacementId() + UnityBanner.this.getLogString());
                    }
                    UnityBanner.this.adClicked(null);
                }

                public void onBannerLeftApplication(BannerView bannerAdView) {
                }
            };
            this.a.setListener(iListener);
        }
        return this.a;
    }

    protected void onBannerLoad() {
        if (this.mNetwork == null) {
            this.adFailedToLoad(new TAdErrorCode(1035, "Unity Ads failed to load ad error with mNetwork == null"));
            return;
        }
        final long l = System.currentTimeMillis();
        ExistsCheck.initUnity(this.mNetwork.getApplicationId(), new IUnityAdsInitializationListener(){

            public void onInitializationComplete() {
                long l2 = System.currentTimeMillis() - l;
                AdLogUtil.Log().d("unity_log", "onInitializationComplete time " + l2);
                if (UnityBanner.this.a != null) {
                    UnityBanner.this.a.load();
                }
            }

            public void onInitializationFailed(UnityAds.UnityAdsInitializationError unityAdsInitializationError, String s) {
                long l2 = System.currentTimeMillis() - l;
                AdLogUtil.Log().d("unity_log", "onInitializationFailed time " + l2);
                UnityBanner.this.adFailedToLoad(new TAdErrorCode(1035, "Unity Ads failed to load ad error with : UnityAds.isInitialized() " + UnityAds.isInitialized()));
            }
        });
    }

    protected void showBanner() {
        if (this.a != null) {
            this.a.setVisibility(0);
            this.adImpression(null);
        } else {
            this.onAdShowError(new TAdErrorCode(1028, "Unity Ads failed to show ad\u3002"));
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("unity_log", "destroy" + this.getLogString());
    }
}

