/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.unity.excuter;

import android.app.Activity;
import android.content.Context;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.ThreadUtils;
import com.hisavana.unity.check.ExistsCheck;
import com.hisavana.unity.util.ActivityUtil;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;

public class UnityVideo
extends BaseVideo {
    private volatile IUnityAdsLoadListener a;
    private IUnityAdsShowListener b;
    private volatile boolean c = false;

    public UnityVideo(Context context, Network network) {
        super(context, network);
    }

    public void destroyAd() {
        super.destroyAd();
        this.a = null;
        this.b = null;
        this.c = false;
        ActivityUtil.releaseRef();
        AdLogUtil.Log().d("unity_log", "destroy" + this.getLogString());
    }

    public boolean isLoaded() {
        return this.c;
    }

    protected void initVideo() {
        this.a = new IUnityAdsLoadListener(){

            public void onUnityAdsAdLoaded(String string) {
                AdLogUtil.Log().d("unity_log", "onUnityAdsAdLoaded");
                UnityVideo.this.adLoaded();
            }

            public void onUnityAdsFailedToLoad(String string, UnityAds.UnityAdsLoadError unityAdsLoadError, String string2) {
                AdLogUtil.Log().e("unity_log", "onUnityAdsFailedToLoad " + UnityVideo.this.getLogString());
                UnityVideo.this.adFailedToLoad(new TAdErrorCode(30003, "Unity Ads failed to load ad for " + string + " with  error: [" + unityAdsLoadError + "] " + string2));
                ActivityUtil.releaseRef();
            }
        };
        this.b = new IUnityAdsShowListener(){

            public void onUnityAdsShowFailure(String string, UnityAds.UnityAdsShowError unityAdsShowError, String string2) {
                AdLogUtil.Log().d("unity_log", "Unity Ads failed to show ad for " + string + " with error: [" + unityAdsShowError + "] " + string2 + UnityVideo.this.getLogString());
                UnityVideo.this.onAdShowError(new TAdErrorCode(50001, string2));
                ActivityUtil.releaseRef();
            }

            public void onUnityAdsShowStart(String string) {
                AdLogUtil.Log().d("unity_log", "onUnityAdsShowStart: " + string);
                UnityVideo.this.adImpression(null);
                ActivityUtil.releaseRef();
            }

            public void onUnityAdsShowClick(String string) {
                AdLogUtil.Log().d("unity_log", "onUnityAdsShowClick: " + string + UnityVideo.this.getLogString());
                UnityVideo.this.adClicked(null);
            }

            public void onUnityAdsShowComplete(String string, UnityAds.UnityAdsShowCompletionState unityAdsShowCompletionState) {
                AdLogUtil.Log().d("unity_log", "onUnityAdsShowComplete: " + string + UnityVideo.this.getLogString());
                if (unityAdsShowCompletionState == UnityAds.UnityAdsShowCompletionState.COMPLETED) {
                    UnityVideo.this.onReward();
                }
                UnityVideo.this.adClosed();
            }
        };
    }

    protected void onVideoStartLoad() {
        ThreadUtils.getIoPool().execute(() -> {
            if (null != this.mNetwork) {
                ExistsCheck.initUnity(this.mNetwork.getApplicationId(), new IUnityAdsInitializationListener(){

                    public void onInitializationComplete() {
                        if (UnityVideo.this.mNetwork != null) {
                            UnityAds.load((String)UnityVideo.this.mNetwork.getCodeSeatId(), (IUnityAdsLoadListener)UnityVideo.this.a);
                            UnityVideo.this.c = true;
                        }
                    }

                    public void onInitializationFailed(UnityAds.UnityAdsInitializationError unityAdsInitializationError, String string) {
                        UnityVideo.this.adFailedToLoad(new TAdErrorCode(30001, string));
                        AdLogUtil.Log().d("unity_log", "UnityAds.isInitialized()" + UnityAds.isInitialized());
                        ActivityUtil.releaseRef();
                    }
                });
            } else {
                this.adFailedToLoad(new TAdErrorCode(30003, "Unity Ads failed to load ,network is null"));
                AdLogUtil.Log().d("unity_log", "network is null");
            }
        });
    }

    protected void onVideoShow(Activity activity) {
        if (null != this.mNetwork && activity != null && this.b != null) {
            UnityAds.show((Activity)activity, (String)this.mNetwork.getCodeSeatId(), (IUnityAdsShowListener)this.b);
        } else {
            this.onAdShowError(new TAdErrorCode(50001, "Unity Ads failed to show ad\u3002"));
        }
    }
}

