/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.unity.excuter;

import android.content.Context;
import android.view.View;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.unity.check.ExistsCheck;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;

public class UnityBanner
extends BaseBanner {
    private BannerView a;
    private final int b;

    public UnityBanner(Context context, Network network, int n) {
        super(context, network);
        this.b = n;
        AdLogUtil.Log().d("unity_log", "bannerSize:=" + n + this.getLogString());
    }

    protected void onBannerDestroy() {
        BannerView bannerView = this.a;
        if (bannerView != null) {
            bannerView.destroy();
            this.a = null;
        }
    }

    protected View getBanner() {
        if (this.a == null && this.mNetwork != null && LifecycleUtil.getTopActivity() != null) {
            BannerView.IListener iListener;
            Object object;
            switch (this.b) {
                default: {
                    UnityBannerSize unityBannerSize;
                    object = unityBannerSize;
                    unityBannerSize = new UnityBannerSize(320, 50);
                    break;
                }
                case 2: {
                    UnityBannerSize unityBannerSize;
                    object = unityBannerSize;
                    unityBannerSize = new UnityBannerSize(320, 250);
                    break;
                }
                case 1: 
                case 3: {
                    UnityBannerSize unityBannerSize;
                    object = unityBannerSize;
                    unityBannerSize = new UnityBannerSize(320, 90);
                    break;
                }
                case 0: {
                    UnityBannerSize unityBannerSize;
                    object = unityBannerSize;
                    unityBannerSize = new UnityBannerSize(320, 50);
                }
            }
            this.a = new BannerView(LifecycleUtil.getTopActivity(), this.mNetwork.getCodeSeatId(), object);
            object = iListener;
            iListener = new BannerView.IListener(){

                public void onBannerLoaded(BannerView bannerView) {
                    AdLogUtil.Log().d("unity_log", "onBannerLoaded");
                    UnityBanner.this.adLoaded();
                }

                public void onBannerShown(BannerView bannerView) {
                }

                public void onBannerFailedToLoad(BannerView bannerView, BannerErrorInfo bannerErrorInfo) {
                    if (bannerView != null && bannerErrorInfo != null) {
                        AdLogUtil.Log().e("unity_log", "onBannerFailedToLoad bannerAdView " + bannerView + " errorInfo " + bannerErrorInfo.errorMessage);
                        AdLogUtil.Log().d("unity_log", "Unity Ads failed to show ad for " + bannerView.getPlacementId() + " with error: [" + bannerErrorInfo.errorCode + "] " + bannerErrorInfo.errorMessage + UnityBanner.this.getLogString());
                        UnityBanner.this.adFailedToLoad(new TAdErrorCode(30003, bannerErrorInfo.errorMessage));
                    } else {
                        UnityBanner.this.adFailedToLoad(new TAdErrorCode(30003, "Unity Ads failed to load ad for "));
                    }
                }

                public void onBannerClick(BannerView bannerView) {
                    if (bannerView != null) {
                        AdLogUtil.Log().d("unity_log", "onUnityAdsShowClick: " + bannerView.getPlacementId() + UnityBanner.this.getLogString());
                    }
                    UnityBanner.this.adClicked(null);
                }

                public void onBannerLeftApplication(BannerView bannerView) {
                }
            };
            this.a.setListener((BannerView.IListener)object);
        }
        return this.a;
    }

    protected void onBannerLoad() {
        if (unityBanner2.mNetwork == null) {
            TAdErrorCode tAdErrorCode;
            UnityBanner unityBanner = unityBanner2;
            UnityBanner unityBanner2 = tAdErrorCode;
            tAdErrorCode = new TAdErrorCode(30003, "Unity Ads failed to load ad error with mNetwork == null");
            unityBanner.adFailedToLoad((TAdErrorCode)unityBanner2);
            return;
        }
        final long l = System.currentTimeMillis();
        ExistsCheck.initUnity(unityBanner2.mNetwork.getApplicationId(), new IUnityAdsInitializationListener(){

            public void onInitializationComplete() {
                long l2 = System.currentTimeMillis() - l;
                AdLogUtil.Log().d("unity_log", "onInitializationComplete time " + l2);
                if (UnityBanner.this.a != null) {
                    UnityBanner.this.a.load();
                }
            }

            public void onInitializationFailed(UnityAds.UnityAdsInitializationError unityAdsInitializationError, String string) {
                long l2 = System.currentTimeMillis() - l;
                AdLogUtil.Log().d("unity_log", "onInitializationFailed, time = " + l2 + ", error=" + unityAdsInitializationError.toString() + ", message=" + string);
                UnityBanner.this.adFailedToLoad(new TAdErrorCode(30001, string));
            }
        });
    }

    protected void showBanner() {
        BannerView bannerView = unityBanner2.a;
        if (bannerView != null) {
            bannerView.setVisibility(0);
            unityBanner2.adImpression(null);
        } else {
            TAdErrorCode tAdErrorCode;
            UnityBanner unityBanner = unityBanner2;
            UnityBanner unityBanner2 = tAdErrorCode;
            tAdErrorCode = new TAdErrorCode(50001, "Unity Ads failed to show ad\u3002");
            unityBanner.onAdShowError((TAdErrorCode)unityBanner2);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("unity_log", "destroy" + this.getLogString());
    }
}

