/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.vungle.check;

import android.content.Context;
import androidx.annotation.NonNull;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.base.BaseNative;
import com.hisavana.common.base.BaseNativeViewHolder;
import com.hisavana.common.base.BaseQueryPrice;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.AdSourceConfig;
import com.hisavana.common.bean.Network;
import com.hisavana.common.interfacz.IBaseAdSummary;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.vungle.excuter.VungleBanner;
import com.hisavana.vungle.excuter.VungleInterstitial;
import com.hisavana.vungle.excuter.VungleVideo;
import com.transsion.core.pool.TranssionPoolManager;
import com.vungle.warren.InitCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;

public class ExistsCheck
implements IBaseAdSummary {
    public static final String VUNGLE_TAG = "vungle_log";

    public void init(@NonNull Context context, AdSourceConfig adSourceConfig) {
        if (null == context || null == adSourceConfig) {
            AdLogUtil.Log().d(VUNGLE_TAG, "Vungle initialize exception");
            return;
        }
        InitCallback initCallback = new InitCallback(){

            public void onSuccess() {
                AdLogUtil.Log().d(ExistsCheck.VUNGLE_TAG, "Vungle SDK initialized");
            }

            public void onError(VungleException vungleException) {
                if (vungleException != null) {
                    AdLogUtil.Log().d(ExistsCheck.VUNGLE_TAG, "Vungle SDK InitCallback - onError: " + vungleException.getLocalizedMessage());
                } else {
                    AdLogUtil.Log().d(ExistsCheck.VUNGLE_TAG, "VungleException is null");
                }
            }

            public void onAutoCacheAdAvailable(String string) {
                AdLogUtil.Log().d(ExistsCheck.VUNGLE_TAG, "Vungle SDK InitCallback - onAutoCacheAdAvailable,Placement Reference ID = " + string);
            }
        };
        TranssionPoolManager.getInstance().addTask(() -> {
            try {
                Vungle.init((String)adSourceConfig.vungleAppID, (Context)context, (InitCallback)initCallback);
            }
            catch (Throwable throwable) {
                AdLogUtil.Log().e("sdk_init", "ExistsCheck --> Vungle--> initialize exception");
            }
        });
    }

    public BaseBanner getBanner(Context context, Network network, int n) {
        VungleBanner vungleBanner = new VungleBanner(context, network, n);
        return vungleBanner;
    }

    public BaseInterstitial getInterstitial(Context context, Network network) {
        VungleInterstitial vungleInterstitial = new VungleInterstitial(context, network);
        return vungleInterstitial;
    }

    public BaseNative getNative(Context context, Network network, int n) {
        return null;
    }

    public BaseNativeViewHolder getNativeViewHolder() {
        return null;
    }

    public BaseSplash getSplash(Context context, Network network) {
        return null;
    }

    public BaseVideo getVideo(Context context, Network network) {
        VungleVideo vungleVideo = new VungleVideo(context, network);
        return vungleVideo;
    }

    public BaseQueryPrice getQueryPrice() {
        return null;
    }
}

