/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.yandex.executer;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.yandex.check.ExistsCheck;
import com.transsion.core.CoreUtil;
import com.yandex.mobile.ads.common.AdError;
import com.yandex.mobile.ads.common.AdRequestConfiguration;
import com.yandex.mobile.ads.common.AdRequestError;
import com.yandex.mobile.ads.common.ImpressionData;
import com.yandex.mobile.ads.interstitial.InterstitialAd;
import com.yandex.mobile.ads.interstitial.InterstitialAdEventListener;
import com.yandex.mobile.ads.interstitial.InterstitialAdLoadListener;
import com.yandex.mobile.ads.interstitial.InterstitialAdLoader;

public class YandexInterstitial
extends BaseInterstitial {
    private final String TAG;
    private InterstitialAdLoader mInterstitialAdLoader;
    private InterstitialAd mInterstitialAd;

    public YandexInterstitial(Context context, Network network) {
        super(context, network);
        this.TAG = "YandexInterstitial";
    }

    static /* synthetic */ InterstitialAd access$002(YandexInterstitial yandexInterstitial, InterstitialAd interstitialAd) {
        yandexInterstitial.mInterstitialAd = interstitialAd;
        return interstitialAd;
    }

    protected void onInterstitialStartLoad() {
        if (this.mInterstitialAdLoader != null && this.mNetwork != null) {
            ExistsCheck.initYandex(() -> this.mInterstitialAdLoader.loadAd(new AdRequestConfiguration.Builder(this.mNetwork.getCodeSeatId()).build()));
            return;
        }
        this.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_FAILED);
    }

    protected void initInterstitial() {
        if (this.mInterstitialAdLoader == null) {
            this.mInterstitialAdLoader = new InterstitialAdLoader(CoreUtil.getContext());
            this.mInterstitialAdLoader.setAdLoadListener(new InterstitialAdLoadListener(){

                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    1 v0 = this;
                    AdLogUtil.Log().d("YandexInterstitial", "banner onAdLoaded" + YandexInterstitial.this.getLogString());
                    v0.YandexInterstitial.this.adLoaded();
                    YandexInterstitial.access$002(v0.YandexInterstitial.this, interstitialAd);
                }

                public void onAdFailedToLoad(@NonNull AdRequestError adRequestError) {
                    AdLogUtil adLogUtil = AdLogUtil.Log();
                    String string = "YandexInterstitial";
                    StringBuilder stringBuilder = new StringBuilder().append("yandex interstitial onAdFailedToLoad").append(object.YandexInterstitial.this.getLogString()).append("----->> error info:");
                    String string2 = adRequestError == null ? "" : adRequestError.toString();
                    adLogUtil.d(string, stringBuilder.append(string2).toString());
                    Object object = object.YandexInterstitial.this;
                    if (adRequestError == null) {
                        adRequestError = TAdErrorCode.ERROR_SHOW_EXCEPTION;
                    } else {
                        TAdErrorCode tAdErrorCode;
                        adLogUtil = tAdErrorCode;
                        AdRequestError adRequestError2 = adRequestError;
                        int n = adRequestError2.getCode();
                        tAdErrorCode = new TAdErrorCode(n, adRequestError2.getDescription());
                        adRequestError = adLogUtil;
                    }
                    ((YandexInterstitial)((Object)object)).adFailedToLoad((TAdErrorCode)adRequestError);
                }
            });
        }
    }

    protected void onInterstitialShow(Activity activity) {
        InterstitialAd interstitialAd = this.mInterstitialAd;
        if (interstitialAd != null && activity != null) {
            interstitialAd.setAdEventListener(new InterstitialAdEventListener(){

                public void onAdShown() {
                    AdLogUtil.Log().d("YandexInterstitial", "Interstitial is onAdImpression" + YandexInterstitial.this.getLogString());
                    YandexInterstitial.this.adImpression(null);
                }

                public void onAdFailedToShow(@NonNull AdError adError) {
                    if (adError != null) {
                        AdLogUtil.Log().w("YandexInterstitial", "ad show failed, error :" + adError + object.YandexInterstitial.this.getLogString());
                    }
                    Object object = object.YandexInterstitial.this;
                    if (adError == null) {
                        adError = TAdErrorCode.ERROR_SHOW_EXCEPTION;
                    } else {
                        TAdErrorCode tAdErrorCode;
                        TAdErrorCode tAdErrorCode2 = tAdErrorCode;
                        tAdErrorCode = new TAdErrorCode(50001, adError.getDescription());
                        adError = tAdErrorCode2;
                    }
                    ((YandexInterstitial)((Object)object)).onAdShowError((TAdErrorCode)adError);
                }

                public void onAdDismissed() {
                    AdLogUtil.Log().d("YandexInterstitial", "Interstitial is Closed" + YandexInterstitial.this.getLogString());
                    YandexInterstitial.this.adClosed();
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d("YandexInterstitial", "Interstitial is clicked" + YandexInterstitial.this.getLogString());
                    YandexInterstitial.this.adClicked(null);
                }

                public void onAdImpression(@Nullable ImpressionData object) {
                    AdLogUtil adLogUtil = AdLogUtil.Log();
                    String string = "YandexInterstitial";
                    StringBuilder stringBuilder = new StringBuilder().append("Interstitial is onAdImpression");
                    object = object == null ? "" : object.getRawData();
                    adLogUtil.d(string, stringBuilder.append((String)object).append(YandexInterstitial.this.getLogString()).toString());
                }
            });
            this.mInterstitialAd.show(activity);
            return;
        }
        this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
    }

    public boolean isLoaded() {
        return this.mInterstitialAd != null;
    }

    public void destroyAd() {
        YandexInterstitial yandexInterstitial = this;
        super.destroyAd();
        InterstitialAdLoader interstitialAdLoader = yandexInterstitial.mInterstitialAdLoader;
        if (interstitialAdLoader != null) {
            interstitialAdLoader.cancelLoading();
            this.mInterstitialAdLoader.setAdLoadListener(null);
            this.mInterstitialAdLoader = null;
        }
        if ((interstitialAdLoader = this.mInterstitialAd) != null) {
            interstitialAdLoader.setAdEventListener(null);
            this.mInterstitialAd = null;
        }
    }
}

