/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.yandex.executer;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.yandex.check.ExistsCheck;
import com.transsion.core.CoreUtil;
import com.yandex.mobile.ads.common.AdError;
import com.yandex.mobile.ads.common.AdRequestConfiguration;
import com.yandex.mobile.ads.common.AdRequestError;
import com.yandex.mobile.ads.common.ImpressionData;
import com.yandex.mobile.ads.rewarded.Reward;
import com.yandex.mobile.ads.rewarded.RewardedAd;
import com.yandex.mobile.ads.rewarded.RewardedAdEventListener;
import com.yandex.mobile.ads.rewarded.RewardedAdLoadListener;
import com.yandex.mobile.ads.rewarded.RewardedAdLoader;

public class YandexVideo
extends BaseVideo {
    private final String TAG;
    private RewardedAdLoader mRewardedAdLoader;
    private RewardedAd mRewardedAd;

    public YandexVideo(Context context, Network network) {
        super(context, network);
        this.TAG = "YandexVideo";
    }

    static /* synthetic */ RewardedAd access$002(YandexVideo yandexVideo, RewardedAd rewardedAd) {
        yandexVideo.mRewardedAd = rewardedAd;
        return rewardedAd;
    }

    protected void initVideo() {
        if (this.mRewardedAdLoader == null) {
            this.mRewardedAdLoader = new RewardedAdLoader(CoreUtil.getContext());
            this.mRewardedAdLoader.setAdLoadListener(new RewardedAdLoadListener(){

                public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                    AdLogUtil adLogUtil = AdLogUtil.Log();
                    String string = "YandexVideo";
                    StringBuilder stringBuilder = new StringBuilder().append("yandex rewarded onAdLoaded").append(YandexVideo.this.getLogString()).append("----->> ad info:");
                    String string2 = rewardedAd == null ? "" : rewardedAd.getInfo();
                    1 v0 = this;
                    adLogUtil.d(string, stringBuilder.append((Object)string2).toString());
                    YandexVideo.access$002(v0.YandexVideo.this, rewardedAd);
                    v0.YandexVideo.this.adLoaded();
                }

                public void onAdFailedToLoad(@NonNull AdRequestError adRequestError) {
                    AdLogUtil adLogUtil = AdLogUtil.Log();
                    String string = "YandexVideo";
                    StringBuilder stringBuilder = new StringBuilder().append("yandex rewarded onAdFailedToLoad").append(object.YandexVideo.this.getLogString()).append("----->> error info:");
                    String string2 = adRequestError == null ? "" : adRequestError.toString();
                    adLogUtil.d(string, stringBuilder.append(string2).toString());
                    Object object = object.YandexVideo.this;
                    if (adRequestError == null) {
                        adRequestError = TAdErrorCode.ERROR_AD_REQUEST_FAILED;
                    } else {
                        TAdErrorCode tAdErrorCode;
                        adLogUtil = tAdErrorCode;
                        AdRequestError adRequestError2 = adRequestError;
                        int n = adRequestError2.getCode();
                        tAdErrorCode = new TAdErrorCode(n, adRequestError2.getDescription());
                        adRequestError = adLogUtil;
                    }
                    ((YandexVideo)((Object)object)).adFailedToLoad((TAdErrorCode)adRequestError);
                }
            });
        }
    }

    protected void onVideoStartLoad() {
        if (this.mRewardedAdLoader == null) {
            this.adFailedToLoad(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            return;
        }
        ExistsCheck.initYandex(() -> this.mRewardedAdLoader.loadAd(new AdRequestConfiguration.Builder(this.mNetwork.getCodeSeatId()).build()));
    }

    protected void onVideoShow(Activity activity) {
        RewardedAd rewardedAd;
        if (activity != null && (rewardedAd = this.mRewardedAd) != null) {
            rewardedAd.setAdEventListener(new RewardedAdEventListener(){

                public void onAdShown() {
                    AdLogUtil.Log().d("YandexVideo", "Rewarded is onAdImpression" + YandexVideo.this.getLogString());
                    YandexVideo.this.adImpression(null);
                }

                public void onAdFailedToShow(@NonNull AdError adError) {
                    if (adError != null) {
                        AdLogUtil.Log().w("YandexVideo", "ad show failed, error :" + adError + object.YandexVideo.this.getLogString());
                    }
                    Object object = object.YandexVideo.this;
                    if (adError == null) {
                        adError = TAdErrorCode.ERROR_SHOW_EXCEPTION;
                    } else {
                        TAdErrorCode tAdErrorCode;
                        TAdErrorCode tAdErrorCode2 = tAdErrorCode;
                        tAdErrorCode = new TAdErrorCode(50001, adError.getDescription());
                        adError = tAdErrorCode2;
                    }
                    ((YandexVideo)((Object)object)).onAdShowError((TAdErrorCode)adError);
                }

                public void onAdDismissed() {
                    2 v0 = this;
                    YandexVideo.access$002(v0.YandexVideo.this, null);
                    AdLogUtil.Log().d("YandexVideo", "YandexVideo --> video is adClosed");
                    v0.YandexVideo.this.adClosed();
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d("YandexVideo", "YandexVideop is clicked" + YandexVideo.this.getLogString());
                    YandexVideo.this.adClicked(null);
                }

                public void onAdImpression(@Nullable ImpressionData impressionData) {
                }

                public void onRewarded(@NonNull Reward reward) {
                    AdLogUtil.Log().d("YandexVideo", "Yandex --> The user earned the reward." + YandexVideo.this.getLogString());
                    YandexVideo.this.onReward();
                }
            });
            this.mRewardedAd.show(activity);
            return;
        }
        this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
    }

    public boolean isLoaded() {
        return this.mRewardedAd != null;
    }

    public void destroyAd() {
        YandexVideo yandexVideo = this;
        super.destroyAd();
        RewardedAdLoader rewardedAdLoader = yandexVideo.mRewardedAdLoader;
        if (rewardedAdLoader != null) {
            rewardedAdLoader.setAdLoadListener(null);
            this.mRewardedAdLoader = null;
        }
        if ((rewardedAdLoader = this.mRewardedAd) != null) {
            rewardedAdLoader.setAdEventListener(null);
            this.mRewardedAd = null;
        }
    }
}

