/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.yandex.executer;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.yandex.check.ExistsCheck;
import com.yandex.mobile.ads.appopenad.AppOpenAd;
import com.yandex.mobile.ads.appopenad.AppOpenAdEventListener;
import com.yandex.mobile.ads.appopenad.AppOpenAdLoadListener;
import com.yandex.mobile.ads.appopenad.AppOpenAdLoader;
import com.yandex.mobile.ads.common.AdError;
import com.yandex.mobile.ads.common.AdRequestConfiguration;
import com.yandex.mobile.ads.common.AdRequestError;
import com.yandex.mobile.ads.common.ImpressionData;

public class YandexSplash
extends BaseSplash<View> {
    private final String TAG;
    private AppOpenAd mAppOpenAd;
    private AppOpenAdLoader mAppOpenAdLoader;

    public YandexSplash(Context context, Network network) {
        super(context, network);
        this.TAG = "YandexSplash";
    }

    static /* synthetic */ AppOpenAd access$202(YandexSplash yandexSplash, AppOpenAd appOpenAd) {
        yandexSplash.mAppOpenAd = appOpenAd;
        return appOpenAd;
    }

    protected void onSplashStartLoad() {
        ExistsCheck.initYandex(() -> {
            if (this.mAppOpenAdLoader == null) {
                this.mAppOpenAdLoader = new AppOpenAdLoader(HSCoreUtil.getContext());
            }
            YandexSplash yandexSplash = this;
            yandexSplash.mAppOpenAdLoader.setAdLoadListener(new AppOpenAdLoadListener(){

                public void onAdLoaded(@NonNull AppOpenAd appOpenAd) {
                    AdLogUtil adLogUtil = AdLogUtil.Log();
                    String string = "YandexSplash";
                    StringBuilder stringBuilder = new StringBuilder().append("yandex appOpenAd onAdLoaded").append(YandexSplash.this.getLogString()).append("----->> ad info:");
                    String string2 = appOpenAd == null ? "" : appOpenAd.getInfo();
                    1 v0 = this;
                    adLogUtil.d(string, stringBuilder.append((Object)string2).toString());
                    YandexSplash.access$202(v0.YandexSplash.this, appOpenAd);
                    v0.YandexSplash.this.adLoaded();
                }

                public void onAdFailedToLoad(@NonNull AdRequestError adRequestError) {
                    AdLogUtil adLogUtil = AdLogUtil.Log();
                    String string = "YandexSplash";
                    StringBuilder stringBuilder = new StringBuilder().append("yandex appOpenAd onAdFailedToLoad").append(object.YandexSplash.this.getLogString()).append("----->> error info:");
                    String string2 = adRequestError == null ? "" : adRequestError.toString();
                    adLogUtil.d(string, stringBuilder.append(string2).toString());
                    Object object = object.YandexSplash.this;
                    if (adRequestError == null) {
                        adRequestError = TAdErrorCode.ERROR_AD_REQUEST_FAILED;
                    } else {
                        TAdErrorCode tAdErrorCode;
                        adLogUtil = tAdErrorCode;
                        AdRequestError adRequestError2 = adRequestError;
                        int n = adRequestError2.getCode();
                        tAdErrorCode = new TAdErrorCode(n, adRequestError2.getDescription());
                        adRequestError = adLogUtil;
                    }
                    ((YandexSplash)((Object)object)).adFailedToLoad((TAdErrorCode)adRequestError);
                }
            });
            yandexSplash.mAppOpenAdLoader.loadAd(new AdRequestConfiguration.Builder(this.mNetwork.getCodeSeatId()).build());
        });
    }

    protected View getSplash() {
        if (HSCoreUtil.getContext() != null) {
            return new View(HSCoreUtil.getContext().getApplicationContext());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onSplashShow() {
        try {
            Activity activity = LifecycleUtil.getMainActivity();
            AppOpenAd appOpenAd = this.mAppOpenAd;
            if (appOpenAd != null && activity != null) {
                appOpenAd.setAdEventListener(new AppOpenAdEventListener(){

                    public void onAdShown() {
                        AdLogUtil.Log().d("YandexSplash", "Splash is onAdImpression" + YandexSplash.this.getLogString());
                        YandexSplash.this.adImpression(null);
                    }

                    public void onAdFailedToShow(@NonNull AdError adError) {
                        if (adError != null) {
                            AdLogUtil.Log().w("YandexSplash", "ad show failed, error :" + adError + object.YandexSplash.this.getLogString());
                        }
                        Object object = object.YandexSplash.this;
                        if (adError == null) {
                            adError = TAdErrorCode.ERROR_SHOW_EXCEPTION;
                        } else {
                            TAdErrorCode tAdErrorCode;
                            TAdErrorCode tAdErrorCode2 = tAdErrorCode;
                            tAdErrorCode = new TAdErrorCode(50001, adError.getDescription());
                            adError = tAdErrorCode2;
                        }
                        ((YandexSplash)((Object)object)).onAdShowError((TAdErrorCode)adError);
                    }

                    public void onAdDismissed() {
                        AdLogUtil.Log().d("YandexSplash", "Splash is Closed" + YandexSplash.this.getLogString());
                        YandexSplash.this.adClosed();
                    }

                    public void onAdClicked() {
                        AdLogUtil.Log().d("YandexSplash", "Splash is clicked" + YandexSplash.this.getLogString());
                        YandexSplash.this.adClicked(null);
                    }

                    public void onAdImpression(@Nullable ImpressionData impressionData) {
                    }
                });
                this.mAppOpenAd.show(activity);
                return;
            }
            this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            return;
        }
        catch (Exception exception) {
            AdLogUtil.Log().w("YandexSplash", "yandex onSplashShow error:" + exception.getMessage());
            this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
        }
    }

    public void destroyAd() {
        YandexSplash yandexSplash = this;
        super.destroyAd();
        AppOpenAd appOpenAd = yandexSplash.mAppOpenAd;
        if (appOpenAd != null) {
            appOpenAd.setAdEventListener(null);
            this.mAppOpenAd = null;
        }
    }
}

