package com.hisavana.admob.ad;

import static com.google.android.gms.ads.nativead.NativeAdAssetNames.ASSET_ADCHOICES_CONTAINER_VIEW;
import static com.google.android.gms.ads.nativead.NativeAdAssetNames.ASSET_ADVERTISER;
import static com.google.android.gms.ads.nativead.NativeAdAssetNames.ASSET_CALL_TO_ACTION;
import static com.google.android.gms.ads.nativead.NativeAdAssetNames.ASSET_HEADLINE;
import static com.google.android.gms.ads.nativead.NativeAdAssetNames.ASSET_ICON;
import static com.google.android.gms.ads.nativead.NativeAdAssetNames.ASSET_MEDIA_VIDEO;
import static com.google.android.gms.ads.nativead.NativeAdAssetNames.ASSET_PRICE;
import static com.google.android.gms.ads.nativead.NativeAdAssetNames.ASSET_STAR_RATING;

import android.net.Uri;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.api.view.MediaView;
import com.cloud.hisavana.sdk.api.view.TNativeView;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.hisavana.admob.util.AdapterUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HisavanaNativeAdMapper extends UnifiedNativeAdMapper {

    private final TaNativeInfo taNativeInfo;
    private final TNative tNative;
    private MediaView mediaView;

    public HisavanaNativeAdMapper(TaNativeInfo ad, NativeAdOptions nativeAdOptions, TNative tNative) {
        taNativeInfo = ad;
        this.tNative = tNative;
        setHeadline(taNativeInfo.getTitle());
        setAdvertiser(taNativeInfo.getDescription());
        setCallToAction(taNativeInfo.getCtatext());
        try {
            if (!TextUtils.isEmpty(taNativeInfo.getRating())) {
                setStarRating(Double.parseDouble(taNativeInfo.getRating()));
            }
            if (!TextUtils.isEmpty(taNativeInfo.getPrice())) {
                NumberFormat formatter = NumberFormat.getCurrencyInstance();
                String priceString = formatter.format(Double.parseDouble(taNativeInfo.getPrice()));
                setPrice(priceString);
            }
        } catch (Exception e) {
            AdapterUtil.logE( "HisavanaNativeAdMapper ---->" + e.getMessage());
        }
        setIcon(new HisavanaNativeMappedImage(ad.getIconImage().getDrawable(), Uri.parse(ad.getIconImage().getImgUrl())));
        List<NativeAd.Image> imagesList = new ArrayList<NativeAd.Image>();
        imagesList.add(new HisavanaNativeMappedImage(ad.getImage().getDrawable(), Uri.parse(ad.getImage().getImgUrl())));
        setImages(imagesList);
        mediaView = new MediaView(CoreUtil.getContext());
        setMediaView(mediaView);
        //广告标识
        setAdChoicesContent(new ImageView(CoreUtil.getContext()));
        setOverrideClickHandling(false);
        setOverrideImpressionRecording(false);

    }

    @Override
    public void trackViews(View containerView, Map<String, View> clickableAssetViews,
                           Map<String, View> nonClickableAssetViews) {
        if (containerView instanceof ViewGroup){
            TNativeView nativeView = new TNativeView(CoreUtil.getContext());
            AdChoicesView adChoicesView = new AdChoicesView(CoreUtil.getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(ScreenUtil.dip2px(12), ScreenUtil.dip2px(12));
            layoutParams.gravity = Gravity.TOP|Gravity.RIGHT;
            nativeView.setMediaView(mediaView, ImageView.ScaleType.FIT_XY);
            nativeView.setAdChoiceView(adChoicesView);
            nativeView.setupViews(taNativeInfo);
            //广告标识
            ((ViewGroup)containerView).addView(adChoicesView,layoutParams);
            List<View> adContains = new ArrayList<>();
            adContains.add(clickableAssetViews.get(ASSET_HEADLINE));
            adContains.add(clickableAssetViews.get(ASSET_ICON));
            adContains.add(clickableAssetViews.get(ASSET_CALL_TO_ACTION));
            adContains.add(clickableAssetViews.get(ASSET_ADVERTISER));
            adContains.add(clickableAssetViews.get(ASSET_PRICE));
            adContains.add(clickableAssetViews.get(ASSET_STAR_RATING));
            adContains.add(clickableAssetViews.get(ASSET_MEDIA_VIDEO));
            adContains.add(clickableAssetViews.get(ASSET_ADCHOICES_CONTAINER_VIEW));
            // 曝光监测
            tNative.registerViews((ViewGroup) containerView, adContains, taNativeInfo);
        }
    }


    @Override
    public void untrackView(View view) {
        super.untrackView(view);
        // Here you would remove any trackers from the View added in trackView.

    }

}