/*
 * Copyright (C) 2014 Google, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hisavana.admob.listener;

import com.cloud.hisavana.sdk.api.adx.TBannerView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import com.hisavana.admob.util.HisavanaCustomEventError;

public class HisavanaBannerEventForwarder extends AdListener {
    private CustomEventBannerListener mBannerListener;
    private TBannerView mAdView;

    public HisavanaBannerEventForwarder(
            CustomEventBannerListener listener, TBannerView adView) {
        this.mBannerListener = listener;
        this.mAdView = adView;
    }

    @Override
    public void onAdLoaded() {
        mBannerListener.onAdLoaded(mAdView);
        mAdView.show();
    }

    @Override
    public void onError(TaErrorCode adError) {
        mBannerListener.onAdFailedToLoad(HisavanaCustomEventError.createSdkError(adError));
    }


    @Override
    public void onAdClicked(TaNativeInfo info) {
        mBannerListener.onAdClicked();
    }

    @Override
    public void onAdClosed() {
        mBannerListener.onAdClosed();
    }

    @Override
    public void onAdShow() {
        mBannerListener.onAdOpened();
    }
}
