package com.hisavana.admob.util;

import android.util.Log;

import com.hisavana.admob.BuildConfig;


/**
 * @author luowenjing
 * @date :2022/8/16
 * @description:
 */
public class AdapterUtil {
    private static final String TAG = "hs_admob_adapter";

    /**
     * 日志输出控制
     */
    private static final boolean IS_LOGGABLE = Log.isLoggable(TAG, Log.DEBUG);

    public static boolean isDebug() {
        return BuildConfig.IS_DEBUG;
    }

    public static void logW(String msg) {
        if (isDebug() || IS_LOGGABLE) {
            Log.w(TAG, msg);
        }
    }

    public static void logE(String msg) {
        if (isDebug() || IS_LOGGABLE) {
            Log.e(TAG, msg);
        }
    }

}
