package com.hisavana.admob.ad;

import android.content.Context;
import android.os.Bundle;

import com.cloud.hisavana.sdk.api.adx.TBannerView;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import com.hisavana.admob.Constants;
import com.hisavana.admob.listener.HisavanaBannerEventForwarder;
import com.hisavana.admob.util.AdapterUtil;
import com.hisavana.admob.util.HisavanaCustomEventError;

public class HisavanaBanner {
    private TBannerView mBannerView;
    private String unit_id = "";

    public void onDestroy() {
        if (mBannerView != null) {
            mBannerView.destroy();
            mBannerView = null;
        }
    }

    public void requestBannerAd(Context context,
                                CustomEventBannerListener listener,
                                String serverParameter,
                                AdSize size,
                                MediationAdRequest mediationAdRequest,
                                Bundle customEventExtras) {
        if (customEventExtras != null && customEventExtras.containsKey(Constants.UNIT_ID)) {
            unit_id = customEventExtras.getString(Constants.UNIT_ID);
            AdapterUtil.logW( "HisavanaBannerAdapter  unit id ---->" + unit_id);
        } else {
            listener.onAdFailedToLoad(HisavanaCustomEventError.createCustomEventNoAdIdError());
            AdapterUtil.logW( "HisavanaBannerAdapter ----->" + Constants.Error.ERROR_UNIT_ID_EMPTY);
            return;
        }
        Preconditions.runOnMainThread(() -> {
            mBannerView = new TBannerView(context, unit_id);
            mBannerView.setListener(new HisavanaBannerEventForwarder(listener, mBannerView));
            mBannerView.setPlacementId(unit_id);
            mBannerView.loadAd();
        });
    }
}
