package com.hisavana.admob.ad;

import android.content.Context;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.cloud.hisavana.sdk.api.adx.TInterstitial;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitialListener;
import com.hisavana.admob.Constants;
import com.hisavana.admob.listener.HisavanaInterstitialEventForwarder;
import com.hisavana.admob.util.AdapterUtil;
import com.hisavana.admob.util.HisavanaCustomEventError;

public class HisavanaInterstitial{
    private TInterstitial mAdInterstitial;
    private String unit_id = "";

    public void requestInterstitialAd(@NonNull Context context, @NonNull CustomEventInterstitialListener customEventInterstitialListener, @Nullable String s, @NonNull MediationAdRequest mediationAdRequest, @Nullable Bundle customEventExtras) {
        if (customEventExtras != null && customEventExtras.containsKey(Constants.UNIT_ID)) {
            unit_id = customEventExtras.getString(Constants.UNIT_ID);
            AdapterUtil.logW( "HisavanaInterstitialAdapter  unit id ---->" + unit_id);
        } else {
            customEventInterstitialListener.onAdFailedToLoad(HisavanaCustomEventError.createCustomEventNoAdIdError());
            AdapterUtil.logE( "HisavanaInterstitialAdapter ----->" + Constants.Error.ERROR_UNIT_ID_EMPTY);
            return;
        }
        Preconditions.runOnMainThread(() -> {
            mAdInterstitial = new TInterstitial(unit_id);
            mAdInterstitial.setListener(new HisavanaInterstitialEventForwarder(customEventInterstitialListener));
            mAdInterstitial.loadAd();
        });
    }

    public void showInterstitial() {
        if (mAdInterstitial != null){
            mAdInterstitial.show();
        }
    }

    public void onDestroy() {
        if (null != mAdInterstitial) {
            mAdInterstitial.destroy();
        }
    }
}
