package com.hisavana.admob.ad;

import android.content.Context;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventNativeListener;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.hisavana.admob.Constants;
import com.hisavana.admob.listener.HisavanaNativeEventForwarder;
import com.hisavana.admob.util.AdapterUtil;
import com.hisavana.admob.util.HisavanaCustomEventError;

public class HisavanaNative {
    private TNative nativeAd;
    private String unit_id = "";

    public void requestNativeAd(@NonNull Context context, @NonNull CustomEventNativeListener customEventNativeListener, @Nullable String s, @NonNull NativeMediationAdRequest nativeMediationAdRequest, @Nullable Bundle customEventExtras) {
        if (customEventExtras != null && customEventExtras.containsKey(Constants.UNIT_ID)) {
            unit_id = customEventExtras.getString(Constants.UNIT_ID);
            AdapterUtil.logW("HisavanaNativeAdapter unit id ---->" + unit_id);
        } else {
            customEventNativeListener.onAdFailedToLoad(HisavanaCustomEventError.createCustomEventNoAdIdError());
            AdapterUtil.logE("HisavanaNativeAdapter ----->" + Constants.Error.ERROR_UNIT_ID_EMPTY);
            return;
        }
        Preconditions.runOnMainThread(() -> {
            NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdRequestOptions();
            nativeAd = new TNative(unit_id);
            nativeAd.setListener(new HisavanaNativeEventForwarder(customEventNativeListener, nativeAdOptions, nativeAd));
            nativeAd.loadAd();
        });
    }

    public void onDestroy() {
        if (null != nativeAd) {
            nativeAd.destroy();
        }
    }
}
