package com.hisavana.admob.ad;

import android.graphics.drawable.Drawable;
import android.net.Uri;

import com.google.android.gms.ads.formats.NativeAd;

public class HisavanaNativeMappedImage extends NativeAd.Image {
    private Drawable drawable;
    private Uri imageUri;
    private double scale;
    public static final double SDK_IMAGE_SCALE = 1.0;
    public HisavanaNativeMappedImage(Drawable drawable, Uri imageUri) {
        this.drawable = drawable;
        this.imageUri = imageUri;
        this.scale = SDK_IMAGE_SCALE;
    }

    public HisavanaNativeMappedImage(Drawable drawable, Uri imageUri, double scale) {
        this.drawable = drawable;
        this.imageUri = imageUri;
        this.scale = scale;
    }

    @Override
    public Drawable getDrawable() {
        return drawable;
    }

    @Override
    public Uri getUri() {
        return imageUri;
    }

    @Override
    public double getScale() {
        return scale;
    }
}
