/*
 * Copyright (C) 2014 Google, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hisavana.admob.listener;

import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitialListener;
import com.hisavana.admob.util.HisavanaCustomEventError;

public class HisavanaInterstitialEventForwarder extends AdListener {
    private CustomEventInterstitialListener mInterstitialListener;

    public HisavanaInterstitialEventForwarder(CustomEventInterstitialListener listener) {
        this.mInterstitialListener = listener;
    }

    @Override
    public void onAdLoaded() {
        mInterstitialListener.onAdLoaded();
    }

    @Override
    public void onError(TaErrorCode adError)  {
        mInterstitialListener.onAdFailedToLoad(HisavanaCustomEventError.createSdkError(adError));
    }

    @Override
    public void onAdClicked() {
        mInterstitialListener.onAdClicked();
    }

    @Override
    public void onAdShow() {
        mInterstitialListener.onAdOpened();
    }

    @Override
    public void onAdClosed() {
        mInterstitialListener.onAdClosed();
    }
}
