/*
 * Copyright (C) 2014 Google, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hisavana.admob.listener;

import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.google.android.gms.ads.mediation.customevent.CustomEventNativeListener;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.hisavana.admob.ad.HisavanaNativeAdMapper;
import com.hisavana.admob.util.HisavanaCustomEventError;

import java.util.List;


public class HisavanaNativeEventForwarder extends AdListener {
    private CustomEventNativeListener nativeListener;
    private NativeAdOptions nativeAdOptions;
    private TNative tNative;

    public HisavanaNativeEventForwarder(CustomEventNativeListener listener, NativeAdOptions options, TNative tNative) {
        this.nativeListener = listener;
        this.nativeAdOptions = options;
        this.tNative = tNative;
    }

    @Override
    public void onAdLoaded(List<TaNativeInfo> adInfos) {
        if (adInfos != null && adInfos.size() > 0 && adInfos.get(0) != null && tNative != null) {
            HisavanaNativeAdMapper mapper =
                    new HisavanaNativeAdMapper(adInfos.get(0),nativeAdOptions,tNative);
            nativeListener.onAdLoaded(mapper);
        }else {
            nativeListener.onAdFailedToLoad(HisavanaCustomEventError.createCustomEventAdNotAvailableError());
        }
    }

    @Override
    public void onError(TaErrorCode adError) {
        nativeListener.onAdFailedToLoad(HisavanaCustomEventError.createSdkError(adError));
    }

    @Override
    public void onAdShow() {
        nativeListener.onAdOpened();
    }

    @Override
    public void onAdClicked() {
        nativeListener.onAdClicked();
    }

    @Override
    public void onAdClosed() {
        nativeListener.onAdClosed();
    }

}