/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admob.listener;

import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.mediation.customevent.CustomEventNativeListener;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.hisavana.admob.ad.HisavanaNativeAdMapper;
import com.hisavana.admob.util.HisavanaCustomEventError;
import java.util.List;

public class HisavanaNativeEventForwarder
extends AdListener {
    public CustomEventNativeListener nativeListener;
    public NativeAdOptions nativeAdOptions;
    public TNative tNative;

    public HisavanaNativeEventForwarder(CustomEventNativeListener customEventNativeListener, NativeAdOptions nativeAdOptions, TNative tNative) {
        this.nativeListener = customEventNativeListener;
        this.nativeAdOptions = nativeAdOptions;
        this.tNative = tNative;
    }

    public void onAdLoaded(List<TaNativeInfo> list) {
        if (list != null && list.size() > 0 && list.get(0) != null && this.tNative != null) {
            HisavanaNativeAdMapper hisavanaNativeAdMapper;
            HisavanaNativeAdMapper hisavanaNativeAdMapper2 = hisavanaNativeAdMapper;
            hisavanaNativeAdMapper = new HisavanaNativeAdMapper(list.get(0), this.nativeAdOptions, this.tNative);
            this.nativeListener.onAdLoaded((UnifiedNativeAdMapper)hisavanaNativeAdMapper2);
        } else {
            this.nativeListener.onAdFailedToLoad(HisavanaCustomEventError.createCustomEventAdNotAvailableError());
        }
    }

    public void onError(TaErrorCode taErrorCode) {
        this.nativeListener.onAdFailedToLoad(HisavanaCustomEventError.createSdkError(taErrorCode));
    }

    public void onAdShow() {
        this.nativeListener.onAdOpened();
    }

    public void onAdClicked() {
        this.nativeListener.onAdClicked();
    }

    public void onAdClosed() {
        this.nativeListener.onAdClosed();
    }
}

