/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admob.ad;

import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.api.adx.TBannerView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.hisavana.admob.util.AdapterUtil;
import com.hisavana.admob.util.HisavanaCustomEventError;
import com.transsion.core.CoreUtil;

public class HisavanaBanner
extends AdListener
implements MediationBannerAd {
    private TBannerView mBannerView;
    @NonNull
    private final MediationBannerAdConfiguration mediationBannerAdConfiguration;
    @NonNull
    private final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback;
    private MediationBannerAdCallback bannerAdCallback;

    public HisavanaBanner(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback) {
        this.mediationBannerAdConfiguration = mediationBannerAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
    }

    public void requestBannerAd() {
        String string = this.mediationBannerAdConfiguration.getServerParameters().getString("parameter");
        if (TextUtils.isEmpty((CharSequence)string)) {
            AdapterUtil.logW("[BannerAdapter] requestBannerAd failed, reason: Hisavana unit id is empty");
            this.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createCustomEventNoAdIdError());
            return;
        }
        Preconditions.runOnMainThread(() -> {
            TBannerView tBannerView;
            TBannerView tBannerView2;
            HisavanaBanner hisavanaBanner = this;
            AdapterUtil.logD("[BannerAdapter] Start request banner ad, adId is: " + string);
            TBannerView tBannerView3 = tBannerView2 = tBannerView;
            tBannerView3(CoreUtil.getContext(), string);
            this.mBannerView = tBannerView3;
            tBannerView.setListener((AdListener)this);
            hisavanaBanner.mBannerView.setPlacementId(string);
            hisavanaBanner.mBannerView.loadAd();
        });
    }

    public void destroyAd() {
        if (this.mBannerView != null) {
            AdapterUtil.logW("[BannerAdapter] destroyAd");
            this.mBannerView.destroy();
            this.mBannerView = null;
        }
    }

    @NonNull
    public View getView() {
        HisavanaBanner hisavanaBanner = hisavanaBanner.mBannerView;
        if (hisavanaBanner != null) {
            return hisavanaBanner;
        }
        return new View(CoreUtil.getContext());
    }

    public void onAdLoaded() {
        HisavanaBanner hisavanaBanner = hisavanaBanner2;
        AdapterUtil.logD("[BannerAdapter] onAdLoaded");
        hisavanaBanner.bannerAdCallback = (MediationBannerAdCallback)hisavanaBanner.mediationAdLoadCallback.onSuccess((Object)hisavanaBanner2);
        HisavanaBanner hisavanaBanner2 = hisavanaBanner.mBannerView;
        if (hisavanaBanner2 != null) {
            hisavanaBanner2.show();
        } else {
            AdapterUtil.logW("[BannerAdapter] onAdLoaded, but banner view is null and cann't show.");
        }
    }

    public void onError(TaErrorCode taErrorCode) {
        AdapterUtil.logW("[BannerAdapter] onError: " + taErrorCode.getErrorMessage());
        this.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createSdkError(taErrorCode));
    }

    public void onTimeOut() {
        AdapterUtil.logE("[BannerAdapter] onTimeOut");
        this.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createAdLoadTimeoutError());
    }

    public void onAdClicked() {
        AdapterUtil.logD("[BannerAdapter] onAdClicked");
        MediationBannerAdCallback mediationBannerAdCallback = this.bannerAdCallback;
        if (mediationBannerAdCallback != null) {
            mediationBannerAdCallback.onAdOpened();
            this.bannerAdCallback.reportAdClicked();
        }
    }

    public void onAdClosed(TBannerView tBannerView) {
        AdapterUtil.logW("[BannerAdapter] onAdClosed");
        tBannerView = this.bannerAdCallback;
        if (tBannerView != null) {
            tBannerView.onAdClosed();
        }
        this.destroyAd();
    }

    public void onAdShow() {
        AdapterUtil.logW("[BannerAdapter] onAdShow");
        HisavanaBanner hisavanaBanner = hisavanaBanner.bannerAdCallback;
        if (hisavanaBanner != null) {
            hisavanaBanner.reportAdImpression();
        }
    }
}

