/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admob.ad;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.api.adx.TInterstitial;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.hisavana.admob.util.AdapterUtil;
import com.hisavana.admob.util.HisavanaCustomEventError;

public class HisavanaInterstitial
extends AdListener
implements MediationInterstitialAd {
    private TInterstitial mAdInterstitial;
    @NonNull
    private final MediationInterstitialAdConfiguration mediationInterstitialAdConfiguration;
    private MediationInterstitialAdCallback interstitialAdCallback;
    @NonNull
    private final MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> mediationAdLoadCallback;

    public HisavanaInterstitial(@NonNull MediationInterstitialAdConfiguration mediationInterstitialAdConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> mediationAdLoadCallback) {
        this.mediationInterstitialAdConfiguration = mediationInterstitialAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
    }

    public void requestInterstitialAd() {
        String string = this.mediationInterstitialAdConfiguration.getServerParameters().getString("parameter");
        if (TextUtils.isEmpty((CharSequence)string)) {
            AdapterUtil.logW("[InterstitialAdapter] requestBannerAd failed, reason: Hisavana unit id is empty");
            this.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createCustomEventNoAdIdError());
            return;
        }
        Preconditions.runOnMainThread(() -> {
            TInterstitial tInterstitial;
            TInterstitial tInterstitial2;
            AdapterUtil.logD("[InterstitialAdapter] Start request banner ad, adId is: " + string);
            TInterstitial tInterstitial3 = tInterstitial2 = tInterstitial;
            tInterstitial3(string);
            this.mAdInterstitial = tInterstitial3;
            tInterstitial.setListener((AdListener)this);
            this.mAdInterstitial.loadAd();
        });
    }

    public void destroyAd() {
        if (this.mAdInterstitial != null) {
            AdapterUtil.logD("[InterstitialAdapter] destroyAd");
            this.mAdInterstitial.destroy();
            this.mAdInterstitial = null;
        }
    }

    public void showAd(@NonNull Context context) {
        HisavanaInterstitial hisavanaInterstitial = hisavanaInterstitial.mAdInterstitial;
        if (hisavanaInterstitial != null) {
            hisavanaInterstitial.show();
        } else {
            AdapterUtil.logW("[InterstitialAdapter] onAdLoaded, but interstitial object is null and cann't show.");
        }
    }

    public void onAdLoaded() {
        AdapterUtil.logD("[InterstitialAdapter] onAdLoaded");
        this.interstitialAdCallback = (MediationInterstitialAdCallback)this.mediationAdLoadCallback.onSuccess((Object)this);
    }

    public void onError(TaErrorCode taErrorCode) {
        AdapterUtil.logW("[InterstitialAdapter] onError: " + taErrorCode.getErrorMessage());
        this.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createSdkError(taErrorCode));
    }

    public void onTimeOut() {
        AdapterUtil.logW("[InterstitialAdapter] onTimeOut");
        this.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createAdLoadTimeoutError());
    }

    public void onAdClicked() {
        AdapterUtil.logD("[InterstitialAdapter] onAdClicked");
        HisavanaInterstitial hisavanaInterstitial = hisavanaInterstitial.interstitialAdCallback;
        if (hisavanaInterstitial != null) {
            hisavanaInterstitial.reportAdClicked();
        }
    }

    public void onAdShow() {
        AdapterUtil.logD("[InterstitialAdapter] onAdShow");
        MediationInterstitialAdCallback mediationInterstitialAdCallback = this.interstitialAdCallback;
        if (mediationInterstitialAdCallback != null) {
            mediationInterstitialAdCallback.reportAdImpression();
            this.interstitialAdCallback.onAdOpened();
        }
    }

    public void onAdClosed() {
        AdapterUtil.logD("[InterstitialAdapter] onAdClosed");
        MediationInterstitialAdCallback mediationInterstitialAdCallback = this.interstitialAdCallback;
        if (mediationInterstitialAdCallback != null) {
            mediationInterstitialAdCallback.onAdClosed();
        }
        this.destroyAd();
    }
}

