/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admob.ad;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.hisavana.admob.ad.HisavanaNativeAdMapper;
import com.hisavana.admob.util.AdapterUtil;
import com.hisavana.admob.util.HisavanaCustomEventError;
import java.util.List;

public class HisavanaNative
extends AdListener {
    private TNative nativeAd;
    @NonNull
    private final MediationNativeAdConfiguration mediationNativeAdConfiguration;
    @NonNull
    private final MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> mediationAdLoadCallback;
    private MediationNativeAdCallback nativeAdCallback;
    private HisavanaNativeAdMapper mapper;

    public HisavanaNative(@NonNull MediationNativeAdConfiguration mediationNativeAdConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> mediationAdLoadCallback) {
        this.mediationNativeAdConfiguration = mediationNativeAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
    }

    public void requestNativeAd() {
        String string = this.mediationNativeAdConfiguration.getServerParameters().getString("parameter");
        if (TextUtils.isEmpty((CharSequence)string)) {
            AdapterUtil.logE("[NativeAdapter] requestNativeAd failed, reason: Hisavana unit id is empty");
            this.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createCustomEventNoAdIdError());
            return;
        }
        Preconditions.runOnMainThread(() -> {
            TNative tNative;
            TNative tNative2;
            AdapterUtil.logD("[NativeAdapter] Start request banner ad, adId is: " + string);
            TNative tNative3 = tNative2 = tNative;
            tNative3(string);
            this.nativeAd = tNative3;
            tNative.setListener((AdListener)this);
            this.nativeAd.loadAd();
        });
    }

    public void onAdLoaded(List<TaNativeInfo> list) {
        AdapterUtil.logD("[NativeAdapter] onAdLoaded");
        if (list != null && !list.isEmpty() && list.get(0) != null && hisavanaNative3.nativeAd != null) {
            HisavanaNativeAdMapper hisavanaNativeAdMapper;
            HisavanaNative hisavanaNative = hisavanaNative3;
            HisavanaNativeAdMapper hisavanaNativeAdMapper2 = hisavanaNativeAdMapper;
            HisavanaNative hisavanaNative2 = hisavanaNative3;
            HisavanaNative hisavanaNative3 = list.get(0);
            hisavanaNative.mapper = new HisavanaNativeAdMapper((TaNativeInfo)hisavanaNative3, hisavanaNative2.nativeAd);
            hisavanaNative.nativeAdCallback = (MediationNativeAdCallback)hisavanaNative.mediationAdLoadCallback.onSuccess((Object)hisavanaNativeAdMapper2);
        } else {
            hisavanaNative3.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createCustomEventAdNotAvailableError());
        }
    }

    public void onError(TaErrorCode taErrorCode) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = taErrorCode.toString();
        AdapterUtil.logW(String.format("[NativeAdapter] onError: %s.", objectArray3));
        objectArray.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createSdkError(taErrorCode));
    }

    public void onTimeOut() {
        AdapterUtil.logE("[NativeAdapter] onTimeOut");
        this.mediationAdLoadCallback.onFailure(HisavanaCustomEventError.createAdLoadTimeoutError());
    }

    public void onAdShow() {
        AdapterUtil.logD("[NativeAdapter] onAdShow");
        HisavanaNative hisavanaNative = hisavanaNative.nativeAdCallback;
        if (hisavanaNative != null) {
            hisavanaNative.reportAdImpression();
        }
    }

    public void onAdClicked() {
        AdapterUtil.logD("[NativeAdapter] onAdClicked");
        MediationNativeAdCallback mediationNativeAdCallback = this.nativeAdCallback;
        if (mediationNativeAdCallback != null) {
            mediationNativeAdCallback.onAdOpened();
            this.nativeAdCallback.reportAdClicked();
        }
    }

    public void onAdClosed(TaNativeInfo taNativeInfo) {
        AdapterUtil.logD("[NativeAdapter] onAdClosed");
        MediationNativeAdCallback mediationNativeAdCallback = this.nativeAdCallback;
        if (mediationNativeAdCallback != null) {
            mediationNativeAdCallback.onAdClosed();
        }
        if (this.mapper != null) {
            taNativeInfo.destroy();
            this.mapper.destroy();
        }
        this.destroyAd();
    }

    public void destroyAd() {
        TNative tNative = this.nativeAd;
        if (tNative != null) {
            tNative.destroy();
            this.nativeAd = null;
        }
    }
}

