/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admob.ad;

import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.view.MediaView;
import com.cloud.hisavana.sdk.api.view.TNativeView;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.util.StoreUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.hisavana.admob.ad.HisavanaNativeMappedImage;
import com.transsion.core.CoreUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HisavanaNativeAdMapper
extends UnifiedNativeAdMapper {
    @NonNull
    private final TaNativeInfo taNativeInfo;
    @NonNull
    private final TNative tNative;
    private final MediaView mediaView;
    private TNativeView nativeView;
    private ViewGroup containerViewGroup;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HisavanaNativeAdMapper(@NonNull TaNativeInfo taNativeInfo, @NonNull TNative tNative) {
        MediaView mediaView;
        ArrayList arrayList;
        Object object;
        this.taNativeInfo = taNativeInfo;
        this.tNative = tNative;
        if (!TextUtils.isEmpty((CharSequence)taNativeInfo.getTitle())) {
            this.setHeadline(taNativeInfo.getTitle());
        }
        if (!TextUtils.isEmpty((CharSequence)taNativeInfo.getDescriptionText())) {
            this.setBody(taNativeInfo.getDescriptionText());
        }
        if (!TextUtils.isEmpty((CharSequence)taNativeInfo.getCtatext())) {
            this.setCallToAction(taNativeInfo.getCtatext());
        }
        if ((object = this.getMappedImage(taNativeInfo.getIconImage())) != null) {
            this.setIcon((NativeAd.Image)object);
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)taNativeInfo.getRating())) {
                this.setStarRating(Double.parseDouble(taNativeInfo.getRating()));
            }
            if (!TextUtils.isEmpty((CharSequence)taNativeInfo.getPrice())) {
                this.setPrice(NumberFormat.getCurrencyInstance().format(Double.parseDouble(taNativeInfo.getPrice())));
            }
        }
        catch (Exception exception) {}
        object = arrayList;
        arrayList = new ArrayList();
        HisavanaNativeMappedImage hisavanaNativeMappedImage = this.getMappedImage(taNativeInfo.getImage());
        if (hisavanaNativeMappedImage != null) {
            object.add(hisavanaNativeMappedImage);
        }
        TNative tNative2 = tNative;
        HisavanaNativeAdMapper hisavanaNativeAdMapper = this;
        hisavanaNativeAdMapper.setImages((List)object);
        tNative = mediaView;
        hisavanaNativeAdMapper.mediaView = new MediaView(CoreUtil.getContext());
        hisavanaNativeAdMapper.setMediaView((View)tNative);
        tNative = tNative2.getAdChoicesView(CoreUtil.getContext(), taNativeInfo);
        if (tNative != null) {
            this.setAdChoicesContent((View)tNative);
        }
        if (StoreUtil.canShowPsMark((AdsDTO)(taNativeInfo = taNativeInfo.getAdItem())) && taNativeInfo != null && taNativeInfo.getExt() != null && !TextUtils.isEmpty((CharSequence)taNativeInfo.getExt().getStoreTitle())) {
            this.setStore(taNativeInfo.getExt().getStoreTitle());
        }
        HisavanaNativeAdMapper hisavanaNativeAdMapper2 = this;
        hisavanaNativeAdMapper2.setOverrideClickHandling(true);
        hisavanaNativeAdMapper2.setOverrideImpressionRecording(false);
    }

    @Nullable
    private HisavanaNativeMappedImage getMappedImage(AdImage adImage) {
        if (adImage != null && adImage.getDrawable() != null && adImage.getImgUrl() != null) {
            return new HisavanaNativeMappedImage(adImage.getDrawable(), Uri.parse((String)adImage.getImgUrl()));
        }
        return null;
    }

    public void trackViews(@NonNull View view, @NonNull Map<String, View> map, @NonNull Map<String, View> object) {
        ArrayList arrayList;
        TNativeView tNativeView;
        if (!(view instanceof ViewGroup)) {
            return;
        }
        HisavanaNativeAdMapper hisavanaNativeAdMapper = this;
        view = (ViewGroup)view;
        hisavanaNativeAdMapper.containerViewGroup = view;
        object = tNativeView;
        TNativeView tNativeView2 = object;
        tNativeView2(CoreUtil.getContext());
        this.nativeView = tNativeView2;
        tNativeView.setMediaView(this.mediaView, ImageView.ScaleType.FIT_XY);
        hisavanaNativeAdMapper.nativeView.setupViews(this.taNativeInfo);
        object = arrayList;
        ((ArrayList)object)();
        object.add(map.get("3001"));
        object.add(map.get("3003"));
        object.add(map.get("3002"));
        object.add(map.get("3005"));
        object.add(map.get("3007"));
        object.add(map.get("3009"));
        object.add(map.get("3010"));
        arrayList.add(map.get("3011"));
        hisavanaNativeAdMapper.tNative.registerViews((ViewGroup)view, (List)object, this.taNativeInfo);
    }

    public void destroy() {
        TNativeView tNativeView = this.nativeView;
        if (tNativeView != null) {
            tNativeView.destroy();
        }
        if ((tNativeView = this.containerViewGroup) != null) {
            tNativeView.removeAllViews();
        }
        this.taNativeInfo.destroy();
    }
}

