/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admob.util;

import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.google.android.gms.ads.AdError;

public class HisavanaCustomEventError {
    public static final String SAMPLE_SDK_DOMAIN = "com.hisavana.admob.util.sdk";
    public static final String CUSTOM_EVENT_ERROR_DOMAIN = "com.hisavana.admob.util.customevent";
    public static final int NETWORK_ERROR = 9000;
    public static final int NO_AD_CODE = 1002;
    public static final int UNKNOWN_ERROR_CODE = 10001;
    public static final int INVALID_REQUEST = 1017;
    public static final int ERROR_NO_AD_UNIT_ID = 101;
    public static final int ERROR_AD_NOT_AVAILABLE = 102;
    public static final int ERROR_NO_ACTIVITY_CONTEXT = 103;

    private HisavanaCustomEventError() {
    }

    public static AdError createCustomEventNoAdIdError() {
        return new AdError(101, "Ad unit id is empty", CUSTOM_EVENT_ERROR_DOMAIN);
    }

    public static AdError createCustomEventAdNotAvailableError() {
        return new AdError(102, "No ads to show", CUSTOM_EVENT_ERROR_DOMAIN);
    }

    public static AdError createCustomEventNoActivityContextError() {
        return new AdError(103, "An activity context is required to show the sample ad", CUSTOM_EVENT_ERROR_DOMAIN);
    }

    public static AdError createSdkError(TaErrorCode taErrorCode) {
        TaErrorCode taErrorCode2 = taErrorCode;
        int n = HisavanaCustomEventError.getMediationErrorCode(taErrorCode2);
        return new AdError(n, taErrorCode2.getErrorMessage(), SAMPLE_SDK_DOMAIN);
    }

    public static AdError createAdLoadTimeoutError() {
        return new AdError(102, "Ad load timeout.", CUSTOM_EVENT_ERROR_DOMAIN);
    }

    private static int getMediationErrorCode(TaErrorCode taErrorCode) {
        int n = taErrorCode.getErrorCode();
        if (n != 1002) {
            if (n != 1017) {
                if (n != 9000) {
                    if (n != 10001) {
                        return taErrorCode.getErrorCode();
                    }
                    return 0;
                }
                return 2;
            }
            return 1;
        }
        return 3;
    }
}

