package com.hisavana.applovin.adapter;

import android.os.Bundle;
import android.util.Log;

import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;

import java.util.Map;

/**
 * @author xinbing.zhang
 * @date :2022/7/26 16:04
 * @description:
 */
public class AdapterUtil {

    public static final int INNER_ERROR_CODE = 10086;
    private static final String TAG = "hs_al_adapter";

    /**
     * 日志输出控制
     */
    private static final boolean IS_LOGGABLE = Log.isLoggable(TAG, Log.DEBUG);

    private AdapterUtil() {

    }

    /**
     * 当前是否是测试模式
     */
    protected static boolean isTest() {
        return BuildConfig.IS_TEST;
    }

    protected static boolean isDebug() {
        return BuildConfig.IS_DEBUG;
    }

    public static void logW(String msg) {
        if (isDebug() || IS_LOGGABLE) {
            Log.w(TAG, msg);
        }
    }

    public static void logE(String msg) {
        if (isDebug() || IS_LOGGABLE) {
            Log.e(TAG, msg);
        }
    }

    protected static void logMaxAdapterParameters(String msg, MaxAdapterParameters maxAdapterParameters) {
        if (maxAdapterParameters == null) {
            return;
        }
        if (isDebug() || IS_LOGGABLE) {
            String adUnitId = maxAdapterParameters.getAdUnitId();
            Map<String, Object> localExtraParameters = maxAdapterParameters.getLocalExtraParameters();
            Bundle serverParameters = maxAdapterParameters.getServerParameters();
            Bundle customParameters = maxAdapterParameters.getCustomParameters();
            Boolean hasUserConsent = maxAdapterParameters.hasUserConsent();
            Boolean isAgeRestrictedUser = maxAdapterParameters.isAgeRestrictedUser();
            Boolean isDoNotSell = maxAdapterParameters.isDoNotSell();
            String consentString = maxAdapterParameters.getConsentString();
            boolean testing = maxAdapterParameters.isTesting();
            logW("AdapterUtil --> logMaxAdapterParameters --> " + msg
                    + " \n----- adUnitId = " + adUnitId
                    + " \n----- localExtraParameters = " + localExtraParameters
                    + " \n----- serverParameters = " + serverParameters
                    + " \n----- customParameters = " + customParameters.toString()
                    + " \n----- hasUserConsent = " + hasUserConsent
                    + " \n----- isAgeRestrictedUser = " + isAgeRestrictedUser
                    + " \n----- isDoNotSell = " + isDoNotSell
                    + " \n----- consentString = " + consentString
                    + " \n----- testing = " + testing);
        }
    }

    protected static void logMaxAdapterResponseParameters(String msg, MaxAdapterResponseParameters maxAdapterResponseParameters) {
        if (maxAdapterResponseParameters == null) {
            return;
        }
        if (isDebug() || IS_LOGGABLE) {
            final String zoneId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
            long bidExpirationMillis = maxAdapterResponseParameters.getBidExpirationMillis();
            final String bidResponse = maxAdapterResponseParameters.getBidResponse();
            logW("AdapterUtil --> logMaxAdapterResponseParameters --> " + msg
                    + " \n----- zoneId = " + zoneId
                    + " \n----- bidResponse = " + bidResponse
                    + " \n----- bidExpirationMillis = " + bidExpirationMillis
            );
        }
    }
}
