package com.hisavana.applovin.adapter;

import static com.hisavana.applovin.adapter.AdapterUtil.logE;
import static com.hisavana.applovin.adapter.AdapterUtil.logW;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout.LayoutParams;

import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.sdk.AppLovinSdkUtils;
import com.cloud.hisavana.sdk.api.adx.TBannerView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.transsion.core.CoreUtil;

/**
 * @author xinbing.zhang
 * @date :2022/7/26 15:22
 * @description:
 */
public class BannerItemProxy {

    private TBannerView tAdBannerView;

    public BannerItemProxy() {

    }

    public void loadAdViewAd(MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, Activity activity, MaxAdViewAdapterListener maxAdViewAdapterListener) {
        AdapterUtil.logMaxAdapterParameters("Loading the Banner AD", maxAdapterResponseParameters);
        AdapterUtil.logMaxAdapterResponseParameters("Loading the Banner AD", maxAdapterResponseParameters);

        if (null == maxAdapterResponseParameters) {
            if (null != maxAdViewAdapterListener) {
                maxAdViewAdapterListener.onAdViewAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, "null == maxAdapterResponseParameters"));
            }
            return;
        }

        Preconditions.runOnMainThread(() -> {
            tAdBannerView = new TBannerView(CoreUtil.getContext().getApplicationContext(), maxAdapterResponseParameters.getThirdPartyAdPlacementId());
            AdListener listener = new AdListener() {
                @Override
                public void onError(TaErrorCode adError) {
                    logE("loadAdViewAd --> AdListener --> adError = " + adError.getErrorMessage());
                    if (null != maxAdViewAdapterListener) {
                        maxAdViewAdapterListener.onAdViewAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, adError.getErrorMessage()));
                    }
                }

                @Override
                public void onAdLoaded() {
                    logW("loadAdViewAd --> AdListener --> onAdLoaded");
                    if (null != maxAdViewAdapterListener) {
                        tAdBannerView.setVisibility(View.VISIBLE);
                        LayoutParams layoutParams = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, AppLovinSdkUtils.dpToPx(CoreUtil.getContext(), 50));
                        tAdBannerView.setLayoutParams(layoutParams);
                        tAdBannerView.show();
                        maxAdViewAdapterListener.onAdViewAdLoaded(tAdBannerView);
                    }
                }

                @Override
                public void onAdClicked(DownUpPointBean pointBean) {
                    logW("loadAdViewAd --> AdListener --> onAdClicked");
                    if (null != maxAdViewAdapterListener) {
                        maxAdViewAdapterListener.onAdViewAdClicked();
                    }
                }

                @Override
                public void onAdShow() {
                    logW("loadAdViewAd --> AdListener --> onAdShow");
                    if (null != maxAdViewAdapterListener) {
                        maxAdViewAdapterListener.onAdViewAdDisplayed();
                    }
                }

                @Override
                public void onTimeOut() {
                    logE("loadAdViewAd --> AdListener --> onTimeOut");
                    if (null != maxAdViewAdapterListener) {
                        maxAdViewAdapterListener.onAdViewAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, "onTimeOut"));
                    }
                }
            };
            tAdBannerView.setListener(listener);
            tAdBannerView.loadAd();
        });
    }

    public void onDestroy() {
        logW("BannerItemProxy --> onDestroy");
        if (null != tAdBannerView) {
            tAdBannerView.destroy();
        }
    }
}
