package com.hisavana.applovin.adapter;

import static com.hisavana.applovin.adapter.AdapterUtil.logW;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;

import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.sdk.commonutil.athena.PostConstant;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.google.android.exoplayer2.util.Log;
import com.transsion.core.CoreUtil;
import com.transsion.ga.AthenaAnalytics;

/**
 * @author xinbing.zhang
 * @date :2022/7/25 11:35
 * @description: eagllwin
 * <p>
 * 接入文档 https://dash.applovin.com/documentation/mediation/auctions/custom-adapter-android
 * <p>
 * You must implement a subclass of com.applovin.mediation.adapters.MediationAdapterBase.
 * This subclass enables the interface between your mediation adapter and the AppLovin MAX SDK.
 * That interface handles various functions of your SDK, including initialization, versioning, and resource cleanup.
 * <p>
 * MaxAdViewAdapter --> Banner Ads
 * MaxInterstitialAdapter --> Interstitials
 * MaxNativeAdapter --> Native Ads
 */
public class HiSavanaMediationAdapter extends MediationAdapterBase implements MaxInterstitialAdapter, MaxAdViewAdapter {

    private BannerItemProxy bannerItemProxy;
    private NativeItemProxy nativeItemProxy;
    private InterstitialItemProxy interstitialItemProxy;

    public HiSavanaMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
        logW("============== HiSavanaMediationAdapter The constructor executes =================");
    }

    @Override
    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, OnCompletionListener onCompletionListener) {
        AdapterUtil.logMaxAdapterParameters("Output when initialized", maxAdapterInitializationParameters);
        if (null == maxAdapterInitializationParameters || null == activity) {
            if (null != onCompletionListener) {
                onCompletionListener.onCompletion(InitializationStatus.INITIALIZED_FAILURE, "null == maxAdapterInitializationParameters");
            }
            return;
        }

        Bundle serverParameters = maxAdapterInitializationParameters.getServerParameters();
        Preconditions.runOnMainThread(() -> {
            CoreUtil.init(activity.getApplicationContext());
            AdManager.init(new AdManager.AdConfigBuilder()
                    .testRequest(false)
                    .setDebug(AdapterUtil.isDebug())
                    .setAppId(serverParameters.getString("app_id"))
                    .build());
            if (AdapterUtil.isTest()) {
                AthenaAnalytics.setTest(true);
                AdxServerConfig.setAppModle(AdxServerConfig.TEST);
            }
            if (null != onCompletionListener){
                onCompletionListener.onCompletion(InitializationStatus.DOES_NOT_APPLY, "");
            }
            logW("HiSavanaMediationAdapter --> initialize --> AdManager init success");
        });
    }

    /**
     * 覆盖getSdkVersion()方法并实现从该方法返回网络 SDK 版本字符串的代码。
     */
    @Override
    public String getSdkVersion() {
        return PostConstant.getSdkVersion();
    }

    /**
     * 覆盖getAdapterVersion()方法并实现从该方法返回中介适配器版本号的代码。
     * AppLovin 的所有适配器都使用五号版本控制方案：最左边的四个数字对应于网络 SDK 版本，最后一个数字表示次要版本号，指的是适配器版本。
     */
    @Override
    public String getAdapterVersion() {
        return PostConstant.getSdkVersion() + "-1";
    }

    @Override
    public void onDestroy() {
        if (null != bannerItemProxy) {
            bannerItemProxy.onDestroy();
        }
        if (null != nativeItemProxy) {
            nativeItemProxy.onDestroy();
        }
        if (null != interstitialItemProxy) {
            interstitialItemProxy.onDestroy();
        }
    }

    @Override
    public void loadAdViewAd(MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, Activity activity, MaxAdViewAdapterListener maxAdViewAdapterListener) {
        bannerItemProxy = new BannerItemProxy();
        bannerItemProxy.loadAdViewAd(maxAdapterResponseParameters, maxAdFormat, activity, maxAdViewAdapterListener);
    }

    @Override
    public void loadNativeAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxNativeAdAdapterListener maxNativeAdAdapterListener) {
        nativeItemProxy = new NativeItemProxy();
        nativeItemProxy.loadNativeAd(maxAdapterResponseParameters, activity, maxNativeAdAdapterListener);
    }

    @Override
    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {

        interstitialItemProxy = new InterstitialItemProxy();
        interstitialItemProxy.loadInterstitialAd(maxAdapterResponseParameters, activity, maxInterstitialAdapterListener);
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        if (null != interstitialItemProxy) {
            interstitialItemProxy.showInterstitialAd(maxAdapterResponseParameters, activity, maxInterstitialAdapterListener);
        }
    }
}
