package com.hisavana.applovin.adapter;

import static com.hisavana.applovin.adapter.AdapterUtil.logE;
import static com.hisavana.applovin.adapter.AdapterUtil.logW;

import android.app.Activity;

import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.cloud.hisavana.sdk.api.adx.TInterstitial;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.sdk.commonutil.util.Preconditions;

/**
 * @author xinbing.zhang
 * @date :2022/7/26 15:35
 * @description:
 */
public class InterstitialItemProxy {

    private TInterstitial mAdInterstitial;
    private MaxInterstitialAdapterListener adapterListener;

    public InterstitialItemProxy() {

    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        AdapterUtil.logMaxAdapterParameters("Loading the interstitial AD", maxAdapterResponseParameters);
        AdapterUtil.logMaxAdapterResponseParameters("Loading the interstitial AD", maxAdapterResponseParameters);

        if (null == maxAdapterResponseParameters) {
            if (null != maxInterstitialAdapterListener) {
                maxInterstitialAdapterListener.onInterstitialAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, "null == maxAdapterResponseParameters"));
            }
            return;
        }

        Preconditions.runOnMainThread(() -> {
            adapterListener = maxInterstitialAdapterListener;
            mAdInterstitial = new TInterstitial(maxAdapterResponseParameters.getThirdPartyAdPlacementId());
            AdListener listener = new AdListener() {
                @Override
                public void onError(TaErrorCode adError) {
                    logE("loadInterstitialAd --> AdListener --> onError --> adError = " + adError.getErrorMessage());
                    if (null != adapterListener) {
                        adapterListener.onInterstitialAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, adError.getErrorMessage()));
                    }
                }

                @Override
                public void onAdLoaded() {
                    logW("loadInterstitialAd --> AdListener --> onAdLoaded");
                    if (null != adapterListener) {
                        adapterListener.onInterstitialAdLoaded();
                    }
                }

                @Override
                public void onAdClicked() {
                    logW("loadInterstitialAd --> AdListener --> onAdClicked");
                    if (null != adapterListener) {
                        adapterListener.onInterstitialAdClicked();
                    }
                }

                @Override
                public void onAdShow() {
                    logW("loadInterstitialAd --> AdListener --> onAdShow");
                    if (null != adapterListener) {
                        adapterListener.onInterstitialAdDisplayed();
                    }
                }

                @Override
                public void onTimeOut() {
                    logW("loadInterstitialAd --> AdListener --> onTimeOut");
                    if (null != adapterListener) {
                        adapterListener.onInterstitialAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, "onTimeOut"));
                    }
                }

                @Override
                public void onAdClosed() {
                    logW("loadInterstitialAd --> AdListener --> onAdClosed");
                    if (null != adapterListener) {
                        adapterListener.onInterstitialAdHidden();
                    }
                }
            };
            mAdInterstitial.setListener(listener);
            mAdInterstitial.loadAd();
        });
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        adapterListener = maxInterstitialAdapterListener;
        if (null == adapterListener) {
            logE("InterstitialItemProxy --> showInterstitialAd --> null == adapterListener");
            return;
        }
        MaxAdapterError adapterError = MaxAdapterError.AD_EXPIRED;
        if (null == mAdInterstitial) {
            logE("InterstitialItemProxy --> showInterstitialAd --> null == mAdInterstitial");
            adapterListener.onInterstitialAdDisplayFailed(adapterError);
            return;
        }
        logW("InterstitialItemProxy --> showInterstitialAd --> mAdInterstitial.show()");
        mAdInterstitial.show();
    }

    public void onDestroy() {
        logE("InterstitialItemProxy --> onDestroy");
        if (null != mAdInterstitial) {
            mAdInterstitial.destroy();
        }
        adapterListener = null;
    }

}
