package com.hisavana.applovin.adapter;

import static com.hisavana.applovin.adapter.AdapterUtil.logE;
import static com.hisavana.applovin.adapter.AdapterUtil.logW;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.api.view.MediaView;
import com.cloud.hisavana.sdk.api.view.TNativeView;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.transsion.core.CoreUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xinbing.zhang
 * @date :2022/7/26 15:29
 * @description:
 */
public class NativeItemProxy {

    private TNative nativeAd;
    private TaNativeInfo taNativeInfo;

    public NativeItemProxy() {

    }

    public void loadNativeAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxNativeAdAdapterListener maxNativeAdAdapterListener) {
        AdapterUtil.logMaxAdapterParameters("Loading the Native AD", maxAdapterResponseParameters);
        AdapterUtil.logMaxAdapterResponseParameters("Loading the Native AD", maxAdapterResponseParameters);

        if (null == maxAdapterResponseParameters) {
            if (null != maxNativeAdAdapterListener) {
                maxNativeAdAdapterListener.onNativeAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, "null == maxAdapterResponseParameters"));
            }
            return;
        }

        final String zoneId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        Preconditions.runOnMainThread(() -> {
            AdListener listener = new AdListener() {

                @Override
                public void onError(TaErrorCode adError) {
                    logE("loadNativeAd --> AdListener --> adError = " + adError.getErrorMessage());
                    if (null != maxNativeAdAdapterListener) {
                        maxNativeAdAdapterListener.onNativeAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, adError.getErrorMessage()));
                    }
                }

                @Override
                public void onAdLoaded(List<TaNativeInfo> adInfoList) {
                    logW("loadNativeAd --> AdListener --> onAdLoaded");
                    if (null == adInfoList || adInfoList.isEmpty() || null == adInfoList.get(0)) {
                        if (null != maxNativeAdAdapterListener) {
                            maxNativeAdAdapterListener.onNativeAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, "null == adInfoList || adInfoList.isEmpty() || null == adInfoList.get(0)"));
                        }
                        return;
                    }
                    transformToMaxAd(adInfoList, maxNativeAdAdapterListener, activity);
                }

                @Override
                public void onAdShow() {
                    logW("loadNativeAd --> AdListener --> onAdShow");
                    if (null != maxNativeAdAdapterListener) {
                        maxNativeAdAdapterListener.onNativeAdDisplayed(new Bundle());
                    }
                }

                @Override
                public void onTimeOut() {
                    logE("loadNativeAd --> AdListener --> onTimeOut");
                    if (null != maxNativeAdAdapterListener) {
                        maxNativeAdAdapterListener.onNativeAdLoadFailed(new MaxAdapterError(AdapterUtil.INNER_ERROR_CODE, "onTimeOut"));
                    }
                }

                @Override
                public void onAdClicked() {
                    logW("loadNativeAd --> AdListener --> onAdShow");
                    if (null != maxNativeAdAdapterListener) {
                        maxNativeAdAdapterListener.onNativeAdClicked();
                    }
                }
            };
            nativeAd = new TNative(zoneId);
            nativeAd.setListener(listener);
            nativeAd.loadAd();
        });
    }

    public void onDestroy() {
        logW("NativeItemProxy --> onDestroy");
        if (null != nativeAd) {
            nativeAd.destroy();
        }
        if (null != taNativeInfo) {
            taNativeInfo.destroy();
        }
    }

    private void transformToMaxAd(List<TaNativeInfo> adInfoList, MaxNativeAdAdapterListener maxNativeAdAdapterListener, Activity activity) {
        try {
            // 将JavaBean 转换成 Applovin定义的格式
            taNativeInfo = adInfoList.get(0);
            if (null != maxNativeAdAdapterListener && null != taNativeInfo) {
                MaxNativeAd.Builder builder = new MaxNativeAd.Builder();
                builder.setAdFormat(MaxAdFormat.NATIVE);
                builder.setTitle(taNativeInfo.getTitle());
                builder.setBody(taNativeInfo.getDescription());
                builder.setCallToAction(taNativeInfo.getCtatext());
                //builder.setAdvertiser();
                //builder.setMediaContentAspectRatio();
//                FrameLayout frameLayout = new FrameLayout(CoreUtil.getContext());
//                frameLayout.addView(new AdChoicesView(CoreUtil.getContext()));
//                builder.setOptionsView(frameLayout);
                builder.setOptionsView(new AdChoicesView(CoreUtil.getContext()));

                builder.setMediaView(new MediaView(CoreUtil.getContext()));
                builder.setIconView(new ImageView(CoreUtil.getContext()));
                maxNativeAdAdapterListener.onNativeAdLoaded(new MaxHiSavanaNativeAd(builder, nativeAd, taNativeInfo), new Bundle());
            }
        } catch (Exception e) {
            logW("loadNativeAd --> AdListener --> onAdLoaded --> " + Log.getStackTraceString(e));
        }
    }

    /**
     * Show 的时候会回调
     */
    private static class MaxHiSavanaNativeAd extends MaxNativeAd {

        private final TNative tNative;
        private final TaNativeInfo taNativeInfo;

        public MaxHiSavanaNativeAd(final Builder builder, TNative nativeAd, TaNativeInfo taNativeInfo) {
            super(builder);
            this.tNative = nativeAd;
            this.taNativeInfo = taNativeInfo;
        }

        @Override
        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {

            if (null == tNative || null == taNativeInfo) {
                return;
            }

            try {
                // 创建我们自己的NativeView
                TNativeView nativeView = new TNativeView(CoreUtil.getContext());
                ImageView iconImageView = maxNativeAdView.getIconImageView();
                if (null != iconImageView) {
                    nativeView.setIconView(iconImageView);
                }

                try {
                    ViewGroup mediaContentViewGroup = maxNativeAdView.getMediaContentViewGroup();
                    int childCount = mediaContentViewGroup.getChildCount();
                    if (childCount == 1) {
                        View childAt = mediaContentViewGroup.getChildAt(0);
                        if (childAt instanceof MediaView) {
                            nativeView.setMediaView((MediaView) childAt, ImageView.ScaleType.FIT_CENTER);
                        }
                    }
                } catch (Exception e) {
                    logE("mediaContentViewGroup --> " + Log.getStackTraceString(e));
                }

                try {
                    ViewGroup optionsContentViewGroup = maxNativeAdView.getOptionsContentViewGroup();
                    logE("optionsContentViewGroup = " + optionsContentViewGroup);
                    if (null != optionsContentViewGroup) {
                        AdChoicesView adChoicesView = new AdChoicesView(CoreUtil.getContext());
                        optionsContentViewGroup.addView(adChoicesView);
                        nativeView.setAdChoiceView(adChoicesView);
                    }
                } catch (Exception e) {
                    logE("optionsContentViewGroup --> " + Log.getStackTraceString(e));
                }

                // 渲染View
                nativeView.setupViews(taNativeInfo);
                // 点击事件
                List<View> adContains = new ArrayList<>();
                adContains.add(maxNativeAdView.getTitleTextView());
                adContains.add(maxNativeAdView.getIconImageView());
                adContains.add(maxNativeAdView.getMainView());
                adContains.add(maxNativeAdView.getCallToActionButton());
                adContains.add(maxNativeAdView.getBodyTextView());
                adContains.add(maxNativeAdView);
                // 曝光监测
                tNative.registerViews(maxNativeAdView, adContains, taNativeInfo);
            } catch (Exception e) {
                logE("prepareViewForInteraction --> " + Log.getStackTraceString(e));
            }
        }
    }
}
