package com.hisavana.topon.adapter;

import android.content.Context;
import android.view.View;

import com.anythink.banner.unitgroup.api.CustomBannerAdapter;
import com.cloud.hisavana.sdk.api.adx.TBannerView;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.hisavana.topon.util.AdapterUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.Constants;
import com.hisavana.topon.manager.HisavanaManager;

import java.util.Map;

/**
 * Created  ON 2022/7/25
 *
 * @author :fangxuhui
 */
public class HisavanaBannerAdapter extends CustomBannerAdapter {

    private String unit_id = "";
    private TBannerView mBannerView;


    @Override
    public View getBannerView() {
        return mBannerView;
    }

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> map, Map<String, Object> map1) {
        if (map != null && map.containsKey(Constants.UNIT_ID)) {
            unit_id = (String) map.get(Constants.UNIT_ID);
        } else {
           AdapterUtil.logE( "HisavanaBannerAdapter ----->"+Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
       AdapterUtil.logD( "HisavanaBannerAdapter  unit id ---->"+unit_id);
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if (mBannerView == null) {
                    mBannerView = new TBannerView(context, unit_id);
                    mBannerView.setListener(listener);
                }
                mBannerView.setPlacementId(unit_id);
                mBannerView.loadAd();
            }
        });
    }

    @Override
    public void destory() {
       AdapterUtil.logD( "HisavanaBannerAdapter  destory");
        if (mBannerView != null) {
            mBannerView.destroy();
            mBannerView = null;
        }
    }

    @Override
    public String getNetworkPlacementId() {
        return unit_id;
    }

    @Override
    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    @Override
    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }


    private AdListener listener = new AdListener() {
        @Override
        public void onError(TaErrorCode adError) {
           AdapterUtil.logE( "HisavanaBannerAdapter  onError --->"+adError.getErrorMessage());
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError(adError.getErrorCode() + "", adError.getErrorMessage());
            }
        }

        @Override
        public void onAdLoaded() {
           AdapterUtil.logD( "HisavanaBannerAdapter  onAdLoaded");
            if (mLoadListener != null && mBannerView != null) {
                mBannerView.show();
                mLoadListener.onAdCacheLoaded();
            }
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {
           AdapterUtil.logD( "HisavanaBannerAdapter  onAdClicked");
            if (mImpressionEventListener != null) {
                mImpressionEventListener.onBannerAdClicked();
            }
        }

        @Override
        public void onAdShow() {
           AdapterUtil.logD( "HisavanaBannerAdapter  onAdShow");
            if (mImpressionEventListener != null) {
                mImpressionEventListener.onBannerAdShow();
            }
        }

        @Override
        public void onTimeOut() {
           AdapterUtil.logW( "HisavanaBannerAdapter  onTimeOut");
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_LOAD_AD_TIMEOUT);
            }
        }
    };
}
