package com.hisavana.topon.adapter;

import android.app.Activity;
import android.content.Context;

import com.anythink.interstitial.unitgroup.api.CustomInterstitialAdapter;
import com.cloud.hisavana.sdk.api.adx.TInterstitial;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.Constants;
import com.hisavana.topon.manager.HisavanaManager;
import com.hisavana.topon.util.AdapterUtil;

import java.util.Map;

/**
 * Created  ON 2022/7/26
 *
 * @author :fangxuhui
 */
public class HisavanaInterstitialAdapter extends CustomInterstitialAdapter {

    private String unit_id = "";
    private TInterstitial mTInterstitial;

    @Override
    public void show(Activity activity) {
        if (mTInterstitial != null) {
            mTInterstitial.show();
        }
    }

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> map, Map<String, Object> map1) {
        if (map != null && map.containsKey(Constants.UNIT_ID)) {
            unit_id = (String) map.get(Constants.UNIT_ID);
        } else {
           AdapterUtil.logW( "HisavanaInterstitialAdapter ----->"+Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
       AdapterUtil.logD("HisavanaInterstitialAdapter ------->  unitid == "+unit_id);
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {

                if(mTInterstitial == null){
                    mTInterstitial = new TInterstitial(unit_id);
                    mTInterstitial.setListener(listener);
                }
                mTInterstitial.setPlacementId(unit_id);
                mTInterstitial.loadAd();
            }
        });
    }

    @Override
    public void destory() {
        if (mTInterstitial != null){
            mTInterstitial.destroy();
            mTInterstitial = null;
        }
    }

    @Override
    public String getNetworkPlacementId() {
        return unit_id;
    }

    @Override
    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    @Override
    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }

    @Override
    public boolean isAdReady() {

        return  mTInterstitial == null ? false : mTInterstitial.isReady();
    }

    private AdListener listener = new AdListener() {
        @Override
        public void onError(TaErrorCode adError) {
           AdapterUtil.logE("HisavanaInterstitialAdapter   onError ---->"+adError.getErrorMessage());
            if(mLoadListener!=null){
                mLoadListener.onAdLoadError(adError.getErrorCode()+"",adError.getErrorMessage());
            }
        }

        @Override
        public void onAdLoaded() {
           AdapterUtil.logD("HisavanaInterstitialAdapter   onAdLoaded ");
            if(mLoadListener!=null){
                mLoadListener.onAdCacheLoaded();
            }
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {
           AdapterUtil.logD("HisavanaInterstitialAdapter   onAdClicked ");
            if(mImpressListener!=null){
                mImpressListener.onInterstitialAdClicked();
            }
        }

        @Override
        public void onAdShow() {
           AdapterUtil.logD("HisavanaInterstitialAdapter   onAdShow ");
            if(mImpressListener!=null){
                mImpressListener.onInterstitialAdShow();
            }
        }

        @Override
        public void onTimeOut() {
           AdapterUtil.logW("HisavanaInterstitialAdapter   onTimeOut");
            if(mLoadListener!=null){
                mLoadListener.onAdLoadError("",Constants.Error.ERROR_LOAD_AD_TIMEOUT);
            }
        }

        @Override
        public void onAdClosed() {
           AdapterUtil.logD("HisavanaInterstitialAdapter   onAdClosed");
            if(mImpressListener!=null){
                mImpressListener.onInterstitialAdClose();
            }
        }
    };
}
