package com.hisavana.topon.adapter;


import android.content.Context;

import com.anythink.nativead.unitgroup.api.CustomNativeAdapter;
import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.hisavana.topon.util.AdapterUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.topon.Constants;
import com.hisavana.topon.ad.HisavanaNativeAd;
import com.hisavana.topon.manager.HisavanaManager;

import java.util.List;
import java.util.Map;

/**
 * Created  ON 2022/7/26
 *
 * @author :fangxuhui
 */
public class HisavanaNativeAdapter extends CustomNativeAdapter {

    private String unitid = "";
    private TNative mTNative;
    private Context context;

    @Override
    public void loadCustomNetworkAd(Context context, Map<String, Object> map, Map<String, Object> map1) {
        this.context = context;
        if (map != null && map.containsKey(Constants.UNIT_ID)) {
            unitid = (String) map.get(Constants.UNIT_ID);
        } else {
           AdapterUtil.logE( "HisavanaNativeAdapter --->loadCustomNetworkAd ------->"+Constants.Error.ERROR_UNIT_ID_EMPTY);
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_UNIT_ID_EMPTY);
            }
            return;
        }
       AdapterUtil.logD( "HisavanaNativeAdapter --->loadCustomNetworkAd -------> unit_id="+unitid);
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if (mTNative == null) {
                    mTNative = new TNative(unitid);
                    mTNative.setListener(listener);
                }
                mTNative.setPlacementId(unitid);
                mTNative.loadAd();
            }
        });

    }

    @Override
    public void destory() {
       AdapterUtil.logD( "HisavanaNativeAdapter --->destory");
        if (mTNative != null) {
            mTNative.destroy();
            mTNative = null;
        }
    }

    @Override
    public String getNetworkPlacementId() {
        return unitid;
    }

    @Override
    public String getNetworkSDKVersion() {
        return HisavanaManager.getSdkVersionName();
    }

    @Override
    public String getNetworkName() {
        return HisavanaManager.getNetWorkName();
    }


    /**
     * 回调listener
     */
    private AdListener listener = new AdListener() {

        @Override
        public void onMediaDownloaded(final TaNativeInfo ad) {
           AdapterUtil.logD( ">onMediaDownloaded , image = " + ad.isMediaCached());
        }

        @Override
        public void onError(TaErrorCode adError) {
           AdapterUtil.logD( "HisavanaNativeAdapter --->onError--->"+adError.getErrorMessage());
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError(adError.getErrorCode() + "", adError.getErrorMessage());
            }
        }

        @Override
        public void onAdLoaded(final List<TaNativeInfo> adInfoList) {
           AdapterUtil.logD( "HisavanaNativeAdapter --->onAdLoaded");
            if (mLoadListener != null) {
                if (adInfoList != null && !adInfoList.isEmpty()) {
                    TaNativeInfo taNativeInfo = adInfoList.get(0);
                    if (taNativeInfo != null) {
                        HisavanaNativeAd hisavanaNativeAd = new HisavanaNativeAd(context, mTNative, taNativeInfo);
                        AdChoicesView adChoicesView = new AdChoicesView(context);
                        hisavanaNativeAd.setAdLogoView(adChoicesView);
                        mLoadListener.onAdCacheLoaded(hisavanaNativeAd);
                        return;
                    }
                }
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_AD_EMPTY);
            }
        }

        @Override
        public void onAdShow() {

        }

        @Override
        public void onTimeOut() {
            if (mLoadListener != null) {
                mLoadListener.onAdLoadError("", Constants.Error.ERROR_AD_EMPTY);
            }
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {

        }
    };
}
